// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.CredentialOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import com.azure.resourcemanager.datafactory.models.CredentialOperations;
import com.azure.resourcemanager.datafactory.models.CredentialResource;

public final class CredentialOperationsImpl implements CredentialOperations {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialOperationsImpl.class);

    private final CredentialOperationsClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public CredentialOperationsImpl(CredentialOperationsClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<CredentialResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<CredentialResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<CredentialResource> listByFactory(String resourceGroupName, String factoryName,
        Context context) {
        PagedIterable<CredentialResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CredentialResourceImpl(inner1, this.manager()));
    }

    public Response<CredentialResource> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        String credentialName, CredentialResourceInner credential, String ifMatch, Context context) {
        Response<CredentialResourceInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, credentialName, credential, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CredentialResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CredentialResource createOrUpdate(String resourceGroupName, String factoryName, String credentialName,
        CredentialResourceInner credential) {
        CredentialResourceInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, factoryName, credentialName, credential);
        if (inner != null) {
            return new CredentialResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<CredentialResource> getWithResponse(String resourceGroupName, String factoryName,
        String credentialName, String ifNoneMatch, Context context) {
        Response<CredentialResourceInner> inner = this.serviceClient()
            .getWithResponse(resourceGroupName, factoryName, credentialName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CredentialResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CredentialResource get(String resourceGroupName, String factoryName, String credentialName) {
        CredentialResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, credentialName);
        if (inner != null) {
            return new CredentialResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String credentialName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, credentialName, context);
    }

    public void delete(String resourceGroupName, String factoryName, String credentialName) {
        this.serviceClient().delete(resourceGroupName, factoryName, credentialName);
    }

    private CredentialOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
