// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.datafactory.fluent.DataFlowDebugSessionsClient;
import com.azure.resourcemanager.datafactory.fluent.models.AddDataFlowToDebugSessionResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.CreateDataFlowDebugSessionResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowDebugCommandResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowDebugSessionInfoInner;
import com.azure.resourcemanager.datafactory.models.CreateDataFlowDebugSessionRequest;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugCommandRequest;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugPackage;
import com.azure.resourcemanager.datafactory.models.DeleteDataFlowDebugSessionRequest;
import com.azure.resourcemanager.datafactory.models.QueryDataFlowDebugSessionsResponse;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DataFlowDebugSessionsClient.
 */
public final class DataFlowDebugSessionsClientImpl implements DataFlowDebugSessionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DataFlowDebugSessionsService service;

    /**
     * The service client containing this operation class.
     */
    private final DataFactoryManagementClientImpl client;

    /**
     * Initializes an instance of DataFlowDebugSessionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DataFlowDebugSessionsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = RestProxy.create(DataFlowDebugSessionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DataFactoryManagementClientDataFlowDebugSessions to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DataFactoryManagemen")
    public interface DataFlowDebugSessionsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/createDataFlowDebugSession")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CreateDataFlowDebugSessionRequest request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/queryDataFlowDebugSessions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<QueryDataFlowDebugSessionsResponse>> queryByFactory(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/addDataFlowToDebugSession")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AddDataFlowToDebugSessionResponseInner>> addDataFlow(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") DataFlowDebugPackage request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/deleteDataFlowDebugSession")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeleteDataFlowDebugSessionRequest request,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/executeDataFlowDebugCommand")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> executeCommand(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DataFlowDebugCommandRequest request, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<QueryDataFlowDebugSessionsResponse>> queryByFactoryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CreateDataFlowDebugSessionResponseInner>, CreateDataFlowDebugSessionResponseInner>
        beginCreateAsync(String resourceGroupName, String factoryName, CreateDataFlowDebugSessionRequest request) {
        Mono<Response<Flux<ByteBuffer>>> mono = createWithResponseAsync(resourceGroupName, factoryName, request);
        return this.client
            .<CreateDataFlowDebugSessionResponseInner, CreateDataFlowDebugSessionResponseInner>getLroResult(mono,
                this.client.getHttpPipeline(), CreateDataFlowDebugSessionResponseInner.class,
                CreateDataFlowDebugSessionResponseInner.class, this.client.getContext());
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CreateDataFlowDebugSessionResponseInner>, CreateDataFlowDebugSessionResponseInner>
        beginCreateAsync(String resourceGroupName, String factoryName, CreateDataFlowDebugSessionRequest request,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, factoryName, request, context);
        return this.client
            .<CreateDataFlowDebugSessionResponseInner, CreateDataFlowDebugSessionResponseInner>getLroResult(mono,
                this.client.getHttpPipeline(), CreateDataFlowDebugSessionResponseInner.class,
                CreateDataFlowDebugSessionResponseInner.class, context);
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CreateDataFlowDebugSessionResponseInner>, CreateDataFlowDebugSessionResponseInner>
        beginCreate(String resourceGroupName, String factoryName, CreateDataFlowDebugSessionRequest request) {
        return this.beginCreateAsync(resourceGroupName, factoryName, request).getSyncPoller();
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CreateDataFlowDebugSessionResponseInner>, CreateDataFlowDebugSessionResponseInner>
        beginCreate(String resourceGroupName, String factoryName, CreateDataFlowDebugSessionRequest request,
            Context context) {
        return this.beginCreateAsync(resourceGroupName, factoryName, request, context).getSyncPoller();
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CreateDataFlowDebugSessionResponseInner> createAsync(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request) {
        return beginCreateAsync(resourceGroupName, factoryName, request).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CreateDataFlowDebugSessionResponseInner> createAsync(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request, Context context) {
        return beginCreateAsync(resourceGroupName, factoryName, request, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CreateDataFlowDebugSessionResponseInner create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request) {
        return createAsync(resourceGroupName, factoryName, request).block();
    }

    /**
     * Creates a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for creating data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CreateDataFlowDebugSessionResponseInner create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request, Context context) {
        return createAsync(resourceGroupName, factoryName, request, context).block();
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataFlowDebugSessionInfoInner>> queryByFactorySinglePageAsync(String resourceGroupName,
        String factoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.queryByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<DataFlowDebugSessionInfoInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataFlowDebugSessionInfoInner>> queryByFactorySinglePageAsync(String resourceGroupName,
        String factoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .queryByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DataFlowDebugSessionInfoInner> queryByFactoryAsync(String resourceGroupName, String factoryName) {
        return new PagedFlux<>(() -> queryByFactorySinglePageAsync(resourceGroupName, factoryName),
            nextLink -> queryByFactoryNextSinglePageAsync(nextLink));
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DataFlowDebugSessionInfoInner> queryByFactoryAsync(String resourceGroupName, String factoryName,
        Context context) {
        return new PagedFlux<>(() -> queryByFactorySinglePageAsync(resourceGroupName, factoryName, context),
            nextLink -> queryByFactoryNextSinglePageAsync(nextLink, context));
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFlowDebugSessionInfoInner> queryByFactory(String resourceGroupName, String factoryName) {
        return new PagedIterable<>(queryByFactoryAsync(resourceGroupName, factoryName));
    }

    /**
     * Query all active data flow debug sessions.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFlowDebugSessionInfoInner> queryByFactory(String resourceGroupName, String factoryName,
        Context context) {
        return new PagedIterable<>(queryByFactoryAsync(resourceGroupName, factoryName, context));
    }

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AddDataFlowToDebugSessionResponseInner>>
        addDataFlowWithResponseAsync(String resourceGroupName, String factoryName, DataFlowDebugPackage request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.addDataFlow(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AddDataFlowToDebugSessionResponseInner>> addDataFlowWithResponseAsync(
        String resourceGroupName, String factoryName, DataFlowDebugPackage request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addDataFlow(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AddDataFlowToDebugSessionResponseInner> addDataFlowAsync(String resourceGroupName, String factoryName,
        DataFlowDebugPackage request) {
        return addDataFlowWithResponseAsync(resourceGroupName, factoryName, request)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AddDataFlowToDebugSessionResponseInner> addDataFlowWithResponse(String resourceGroupName,
        String factoryName, DataFlowDebugPackage request, Context context) {
        return addDataFlowWithResponseAsync(resourceGroupName, factoryName, request, context).block();
    }

    /**
     * Add a data flow into debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition with debug content.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure for starting data flow debug session.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AddDataFlowToDebugSessionResponseInner addDataFlow(String resourceGroupName, String factoryName,
        DataFlowDebugPackage request) {
        return addDataFlowWithResponse(resourceGroupName, factoryName, request, Context.NONE).getValue();
    }

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, request).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request, Context context) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, request, context).block();
    }

    /**
     * Deletes a data flow debug session.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug session definition for deletion.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, DeleteDataFlowDebugSessionRequest request) {
        deleteWithResponse(resourceGroupName, factoryName, request, Context.NONE);
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> executeCommandWithResponseAsync(String resourceGroupName,
        String factoryName, DataFlowDebugCommandRequest request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), request, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> executeCommandWithResponseAsync(String resourceGroupName,
        String factoryName, DataFlowDebugCommandRequest request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response body structure of data flow result for data preview,
     * statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataFlowDebugCommandResponseInner>, DataFlowDebugCommandResponseInner>
        beginExecuteCommandAsync(String resourceGroupName, String factoryName, DataFlowDebugCommandRequest request) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = executeCommandWithResponseAsync(resourceGroupName, factoryName, request);
        return this.client.<DataFlowDebugCommandResponseInner, DataFlowDebugCommandResponseInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataFlowDebugCommandResponseInner.class,
            DataFlowDebugCommandResponseInner.class, this.client.getContext());
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response body structure of data flow result for data preview,
     * statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataFlowDebugCommandResponseInner>, DataFlowDebugCommandResponseInner>
        beginExecuteCommandAsync(String resourceGroupName, String factoryName, DataFlowDebugCommandRequest request,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = executeCommandWithResponseAsync(resourceGroupName, factoryName, request, context);
        return this.client.<DataFlowDebugCommandResponseInner, DataFlowDebugCommandResponseInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataFlowDebugCommandResponseInner.class,
            DataFlowDebugCommandResponseInner.class, context);
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response body structure of data flow result for data preview,
     * statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataFlowDebugCommandResponseInner>, DataFlowDebugCommandResponseInner>
        beginExecuteCommand(String resourceGroupName, String factoryName, DataFlowDebugCommandRequest request) {
        return this.beginExecuteCommandAsync(resourceGroupName, factoryName, request).getSyncPoller();
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response body structure of data flow result for data preview,
     * statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataFlowDebugCommandResponseInner>, DataFlowDebugCommandResponseInner>
        beginExecuteCommand(String resourceGroupName, String factoryName, DataFlowDebugCommandRequest request,
            Context context) {
        return this.beginExecuteCommandAsync(resourceGroupName, factoryName, request, context).getSyncPoller();
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DataFlowDebugCommandResponseInner> executeCommandAsync(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request) {
        return beginExecuteCommandAsync(resourceGroupName, factoryName, request).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DataFlowDebugCommandResponseInner> executeCommandAsync(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request, Context context) {
        return beginExecuteCommandAsync(resourceGroupName, factoryName, request, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataFlowDebugCommandResponseInner executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request) {
        return executeCommandAsync(resourceGroupName, factoryName, request).block();
    }

    /**
     * Execute a data flow debug command.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param request Data flow debug command definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body structure of data flow result for data preview, statistics or expression preview.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataFlowDebugCommandResponseInner executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request, Context context) {
        return executeCommandAsync(resourceGroupName, factoryName, request, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataFlowDebugSessionInfoInner>> queryByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.queryByFactoryNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DataFlowDebugSessionInfoInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of active debug sessions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataFlowDebugSessionInfoInner>> queryByFactoryNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.queryByFactoryNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
