// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.DataFlowDebugSessionsClient;
import com.azure.resourcemanager.datafactory.fluent.models.AddDataFlowToDebugSessionResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.CreateDataFlowDebugSessionResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowDebugCommandResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.DataFlowDebugSessionInfoInner;
import com.azure.resourcemanager.datafactory.models.AddDataFlowToDebugSessionResponse;
import com.azure.resourcemanager.datafactory.models.CreateDataFlowDebugSessionRequest;
import com.azure.resourcemanager.datafactory.models.CreateDataFlowDebugSessionResponse;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugCommandRequest;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugCommandResponse;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugPackage;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugSessionInfo;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugSessions;
import com.azure.resourcemanager.datafactory.models.DeleteDataFlowDebugSessionRequest;

public final class DataFlowDebugSessionsImpl implements DataFlowDebugSessions {
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowDebugSessionsImpl.class);

    private final DataFlowDebugSessionsClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public DataFlowDebugSessionsImpl(DataFlowDebugSessionsClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public CreateDataFlowDebugSessionResponse create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request) {
        CreateDataFlowDebugSessionResponseInner inner
            = this.serviceClient().create(resourceGroupName, factoryName, request);
        if (inner != null) {
            return new CreateDataFlowDebugSessionResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public CreateDataFlowDebugSessionResponse create(String resourceGroupName, String factoryName,
        CreateDataFlowDebugSessionRequest request, Context context) {
        CreateDataFlowDebugSessionResponseInner inner
            = this.serviceClient().create(resourceGroupName, factoryName, request, context);
        if (inner != null) {
            return new CreateDataFlowDebugSessionResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<DataFlowDebugSessionInfo> queryByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<DataFlowDebugSessionInfoInner> inner
            = this.serviceClient().queryByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataFlowDebugSessionInfoImpl(inner1, this.manager()));
    }

    public PagedIterable<DataFlowDebugSessionInfo> queryByFactory(String resourceGroupName, String factoryName,
        Context context) {
        PagedIterable<DataFlowDebugSessionInfoInner> inner
            = this.serviceClient().queryByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataFlowDebugSessionInfoImpl(inner1, this.manager()));
    }

    public Response<AddDataFlowToDebugSessionResponse> addDataFlowWithResponse(String resourceGroupName,
        String factoryName, DataFlowDebugPackage request, Context context) {
        Response<AddDataFlowToDebugSessionResponseInner> inner
            = this.serviceClient().addDataFlowWithResponse(resourceGroupName, factoryName, request, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AddDataFlowToDebugSessionResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AddDataFlowToDebugSessionResponse addDataFlow(String resourceGroupName, String factoryName,
        DataFlowDebugPackage request) {
        AddDataFlowToDebugSessionResponseInner inner
            = this.serviceClient().addDataFlow(resourceGroupName, factoryName, request);
        if (inner != null) {
            return new AddDataFlowToDebugSessionResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        DeleteDataFlowDebugSessionRequest request, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, request, context);
    }

    public void delete(String resourceGroupName, String factoryName, DeleteDataFlowDebugSessionRequest request) {
        this.serviceClient().delete(resourceGroupName, factoryName, request);
    }

    public DataFlowDebugCommandResponse executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request) {
        DataFlowDebugCommandResponseInner inner
            = this.serviceClient().executeCommand(resourceGroupName, factoryName, request);
        if (inner != null) {
            return new DataFlowDebugCommandResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public DataFlowDebugCommandResponse executeCommand(String resourceGroupName, String factoryName,
        DataFlowDebugCommandRequest request, Context context) {
        DataFlowDebugCommandResponseInner inner
            = this.serviceClient().executeCommand(resourceGroupName, factoryName, request, context);
        if (inner != null) {
            return new DataFlowDebugCommandResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private DataFlowDebugSessionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
