// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlBatchResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.ExposureControlResponseInner;
import com.azure.resourcemanager.datafactory.models.ExposureControlBatchResponse;
import com.azure.resourcemanager.datafactory.models.ExposureControlResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ExposureControlBatchResponseImpl implements ExposureControlBatchResponse {
    private ExposureControlBatchResponseInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    ExposureControlBatchResponseImpl(ExposureControlBatchResponseInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<ExposureControlResponse> exposureControlResponses() {
        List<ExposureControlResponseInner> inner = this.innerModel().exposureControlResponses();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream()
                .map(inner1 -> new ExposureControlResponseImpl(inner1, this.manager()))
                .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public ExposureControlBatchResponseInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
