// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;
import com.azure.resourcemanager.datafactory.models.GlobalParameterResource;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import java.util.Collections;
import java.util.Map;

public final class GlobalParameterResourceImpl
    implements GlobalParameterResource, GlobalParameterResource.Definition, GlobalParameterResource.Update {
    private GlobalParameterResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public Map<String, GlobalParameterSpecification> properties() {
        Map<String, GlobalParameterSpecification> inner = this.innerModel().properties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public GlobalParameterResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String globalParameterName;

    public GlobalParameterResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    public GlobalParameterResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, globalParameterName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public GlobalParameterResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, globalParameterName, this.innerModel(), context)
            .getValue();
        return this;
    }

    GlobalParameterResourceImpl(String name, com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new GlobalParameterResourceInner();
        this.serviceManager = serviceManager;
        this.globalParameterName = name;
    }

    public GlobalParameterResourceImpl update() {
        return this;
    }

    public GlobalParameterResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, globalParameterName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public GlobalParameterResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, globalParameterName, this.innerModel(), context)
            .getValue();
        return this;
    }

    GlobalParameterResourceImpl(GlobalParameterResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.globalParameterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "globalParameters");
    }

    public GlobalParameterResource refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .getWithResponse(resourceGroupName, factoryName, globalParameterName, Context.NONE)
            .getValue();
        return this;
    }

    public GlobalParameterResource refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGlobalParameters()
            .getWithResponse(resourceGroupName, factoryName, globalParameterName, context)
            .getValue();
        return this;
    }

    public GlobalParameterResourceImpl withProperties(Map<String, GlobalParameterSpecification> properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}
