// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeNodesClient;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeNodeIpAddressInner;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeNodeInner;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeNodeRequest;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in IntegrationRuntimeNodesClient.
 */
public final class IntegrationRuntimeNodesClientImpl implements IntegrationRuntimeNodesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final IntegrationRuntimeNodesService service;

    /**
     * The service client containing this operation class.
     */
    private final DataFactoryManagementClientImpl client;

    /**
     * Initializes an instance of IntegrationRuntimeNodesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    IntegrationRuntimeNodesClientImpl(DataFactoryManagementClientImpl client) {
        this.service = RestProxy.create(IntegrationRuntimeNodesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DataFactoryManagementClientIntegrationRuntimeNodes to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DataFactoryManagemen")
    public interface IntegrationRuntimeNodesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("integrationRuntimeName") String integrationRuntimeName, @PathParam("nodeName") String nodeName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("integrationRuntimeName") String integrationRuntimeName, @PathParam("nodeName") String nodeName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("integrationRuntimeName") String integrationRuntimeName, @PathParam("nodeName") String nodeName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}/ipAddress")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<IntegrationRuntimeNodeIpAddressInner>> getIpAddress(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("integrationRuntimeName") String integrationRuntimeName, @PathParam("nodeName") String nodeName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a self-hosted integration runtime node along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> getWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a self-hosted integration runtime node along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> getWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
            integrationRuntimeName, nodeName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a self-hosted integration runtime node on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SelfHostedIntegrationRuntimeNodeInner> getAsync(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        return getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a self-hosted integration runtime node along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SelfHostedIntegrationRuntimeNodeInner> getWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName, Context context) {
        return getWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context).block();
    }

    /**
     * Gets a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a self-hosted integration runtime node.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SelfHostedIntegrationRuntimeNodeInner get(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        return getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String integrationRuntimeName,
        String nodeName) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context)
            .block();
    }

    /**
     * Deletes a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName) {
        deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, Context.NONE);
    }

    /**
     * Updates a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param updateIntegrationRuntimeNodeRequest The parameters for updating an integration runtime node.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of Self-hosted integration runtime node along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> updateWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        if (updateIntegrationRuntimeNodeRequest == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter updateIntegrationRuntimeNodeRequest is required and cannot be null."));
        } else {
            updateIntegrationRuntimeNodeRequest.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(),
                updateIntegrationRuntimeNodeRequest, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param updateIntegrationRuntimeNodeRequest The parameters for updating an integration runtime node.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of Self-hosted integration runtime node along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SelfHostedIntegrationRuntimeNodeInner>> updateWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        if (updateIntegrationRuntimeNodeRequest == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter updateIntegrationRuntimeNodeRequest is required and cannot be null."));
        } else {
            updateIntegrationRuntimeNodeRequest.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(),
            updateIntegrationRuntimeNodeRequest, accept, context);
    }

    /**
     * Updates a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param updateIntegrationRuntimeNodeRequest The parameters for updating an integration runtime node.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of Self-hosted integration runtime node on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SelfHostedIntegrationRuntimeNodeInner> updateAsync(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest) {
        return updateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName,
            updateIntegrationRuntimeNodeRequest).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param updateIntegrationRuntimeNodeRequest The parameters for updating an integration runtime node.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of Self-hosted integration runtime node along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SelfHostedIntegrationRuntimeNodeInner> updateWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest, Context context) {
        return updateWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName,
            updateIntegrationRuntimeNodeRequest, context).block();
    }

    /**
     * Updates a self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param updateIntegrationRuntimeNodeRequest The parameters for updating an integration runtime node.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of Self-hosted integration runtime node.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SelfHostedIntegrationRuntimeNodeInner update(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest) {
        return updateWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName,
            updateIntegrationRuntimeNodeRequest, Context.NONE).getValue();
    }

    /**
     * Get the IP address of self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the IP address of self-hosted integration runtime node along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeNodeIpAddressInner>> getIpAddressWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getIpAddress(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the IP address of self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the IP address of self-hosted integration runtime node along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeNodeIpAddressInner>> getIpAddressWithResponseAsync(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (integrationRuntimeName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter integrationRuntimeName is required and cannot be null."));
        }
        if (nodeName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nodeName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getIpAddress(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, integrationRuntimeName, nodeName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the IP address of self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the IP address of self-hosted integration runtime node on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<IntegrationRuntimeNodeIpAddressInner> getIpAddressAsync(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        return getIpAddressWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the IP address of self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the IP address of self-hosted integration runtime node along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IntegrationRuntimeNodeIpAddressInner> getIpAddressWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        return getIpAddressWithResponseAsync(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context)
            .block();
    }

    /**
     * Get the IP address of self-hosted integration runtime node.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param nodeName The integration runtime node name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the IP address of self-hosted integration runtime node.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IntegrationRuntimeNodeIpAddressInner getIpAddress(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        return getIpAddressWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, Context.NONE)
            .getValue();
    }
}
