// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeNodesClient;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeNodeIpAddressInner;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeNodeInner;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeNodeIpAddress;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeNodes;
import com.azure.resourcemanager.datafactory.models.SelfHostedIntegrationRuntimeNode;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeNodeRequest;

public final class IntegrationRuntimeNodesImpl implements IntegrationRuntimeNodes {
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeNodesImpl.class);

    private final IntegrationRuntimeNodesClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public IntegrationRuntimeNodesImpl(IntegrationRuntimeNodesClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<SelfHostedIntegrationRuntimeNode> getWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName, Context context) {
        Response<SelfHostedIntegrationRuntimeNodeInner> inner = this.serviceClient()
            .getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SelfHostedIntegrationRuntimeNodeImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SelfHostedIntegrationRuntimeNode get(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        SelfHostedIntegrationRuntimeNodeInner inner
            = this.serviceClient().get(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
        if (inner != null) {
            return new SelfHostedIntegrationRuntimeNodeImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
    }

    public void delete(String resourceGroupName, String factoryName, String integrationRuntimeName, String nodeName) {
        this.serviceClient().delete(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
    }

    public Response<SelfHostedIntegrationRuntimeNode> updateWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest, Context context) {
        Response<SelfHostedIntegrationRuntimeNodeInner> inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName,
                updateIntegrationRuntimeNodeRequest, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SelfHostedIntegrationRuntimeNodeImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SelfHostedIntegrationRuntimeNode update(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName,
        UpdateIntegrationRuntimeNodeRequest updateIntegrationRuntimeNodeRequest) {
        SelfHostedIntegrationRuntimeNodeInner inner = this.serviceClient()
            .update(resourceGroupName, factoryName, integrationRuntimeName, nodeName,
                updateIntegrationRuntimeNodeRequest);
        if (inner != null) {
            return new SelfHostedIntegrationRuntimeNodeImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<IntegrationRuntimeNodeIpAddress> getIpAddressWithResponse(String resourceGroupName,
        String factoryName, String integrationRuntimeName, String nodeName, Context context) {
        Response<IntegrationRuntimeNodeIpAddressInner> inner = this.serviceClient()
            .getIpAddressWithResponse(resourceGroupName, factoryName, integrationRuntimeName, nodeName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new IntegrationRuntimeNodeIpAddressImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public IntegrationRuntimeNodeIpAddress getIpAddress(String resourceGroupName, String factoryName,
        String integrationRuntimeName, String nodeName) {
        IntegrationRuntimeNodeIpAddressInner inner
            = this.serviceClient().getIpAddress(resourceGroupName, factoryName, integrationRuntimeName, nodeName);
        if (inner != null) {
            return new IntegrationRuntimeNodeIpAddressImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private IntegrationRuntimeNodesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
