// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.IntegrationRuntimeObjectMetadatasClient;
import com.azure.resourcemanager.datafactory.fluent.models.SsisObjectMetadataListResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.SsisObjectMetadataStatusResponseInner;
import com.azure.resourcemanager.datafactory.models.GetSsisObjectMetadataRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeObjectMetadatas;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataListResponse;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataStatusResponse;

public final class IntegrationRuntimeObjectMetadatasImpl implements IntegrationRuntimeObjectMetadatas {
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeObjectMetadatasImpl.class);

    private final IntegrationRuntimeObjectMetadatasClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public IntegrationRuntimeObjectMetadatasImpl(IntegrationRuntimeObjectMetadatasClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public SsisObjectMetadataStatusResponse refresh(String resourceGroupName, String factoryName,
        String integrationRuntimeName) {
        SsisObjectMetadataStatusResponseInner inner
            = this.serviceClient().refresh(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new SsisObjectMetadataStatusResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public SsisObjectMetadataStatusResponse refresh(String resourceGroupName, String factoryName,
        String integrationRuntimeName, Context context) {
        SsisObjectMetadataStatusResponseInner inner
            = this.serviceClient().refresh(resourceGroupName, factoryName, integrationRuntimeName, context);
        if (inner != null) {
            return new SsisObjectMetadataStatusResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<SsisObjectMetadataListResponse> getWithResponse(String resourceGroupName, String factoryName,
        String integrationRuntimeName, GetSsisObjectMetadataRequest getMetadataRequest, Context context) {
        Response<SsisObjectMetadataListResponseInner> inner = this.serviceClient()
            .getWithResponse(resourceGroupName, factoryName, integrationRuntimeName, getMetadataRequest, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SsisObjectMetadataListResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SsisObjectMetadataListResponse get(String resourceGroupName, String factoryName,
        String integrationRuntimeName) {
        SsisObjectMetadataListResponseInner inner
            = this.serviceClient().get(resourceGroupName, factoryName, integrationRuntimeName);
        if (inner != null) {
            return new SsisObjectMetadataListResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private IntegrationRuntimeObjectMetadatasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
