// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.LinkedServiceResource;

public final class LinkedServiceResourceImpl
    implements LinkedServiceResource, LinkedServiceResource.Definition, LinkedServiceResource.Update {
    private LinkedServiceResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public LinkedService properties() {
        return this.innerModel().properties();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public LinkedServiceResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String linkedServiceName;

    private String createIfMatch;

    private String updateIfMatch;

    public LinkedServiceResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    public LinkedServiceResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, linkedServiceName, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public LinkedServiceResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, linkedServiceName, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    LinkedServiceResourceImpl(String name, com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new LinkedServiceResourceInner();
        this.serviceManager = serviceManager;
        this.linkedServiceName = name;
        this.createIfMatch = null;
    }

    public LinkedServiceResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public LinkedServiceResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, linkedServiceName, this.innerModel(),
                updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public LinkedServiceResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, linkedServiceName, this.innerModel(),
                updateIfMatch, context)
            .getValue();
        return this;
    }

    LinkedServiceResourceImpl(LinkedServiceResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.linkedServiceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "linkedservices");
    }

    public LinkedServiceResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .getWithResponse(resourceGroupName, factoryName, linkedServiceName, localIfNoneMatch, Context.NONE)
            .getValue();
        return this;
    }

    public LinkedServiceResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getLinkedServices()
            .getWithResponse(resourceGroupName, factoryName, linkedServiceName, localIfNoneMatch, context)
            .getValue();
        return this;
    }

    public LinkedServiceResourceImpl withProperties(LinkedService properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public LinkedServiceResourceImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
