// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedPrivateEndpointResourceInner;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpoint;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpointResource;

public final class ManagedPrivateEndpointResourceImpl implements ManagedPrivateEndpointResource,
    ManagedPrivateEndpointResource.Definition, ManagedPrivateEndpointResource.Update {
    private ManagedPrivateEndpointResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public ManagedPrivateEndpoint properties() {
        return this.innerModel().properties();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ManagedPrivateEndpointResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String managedVirtualNetworkName;

    private String managedPrivateEndpointName;

    private String createIfMatch;

    private String updateIfMatch;

    public ManagedPrivateEndpointResourceImpl withExistingManagedVirtualNetwork(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        this.managedVirtualNetworkName = managedVirtualNetworkName;
        return this;
    }

    public ManagedPrivateEndpointResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName,
                managedPrivateEndpointName, this.innerModel(), createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedPrivateEndpointResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName,
                managedPrivateEndpointName, this.innerModel(), createIfMatch, context)
            .getValue();
        return this;
    }

    ManagedPrivateEndpointResourceImpl(String name,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new ManagedPrivateEndpointResourceInner();
        this.serviceManager = serviceManager;
        this.managedPrivateEndpointName = name;
        this.createIfMatch = null;
    }

    public ManagedPrivateEndpointResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public ManagedPrivateEndpointResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName,
                managedPrivateEndpointName, this.innerModel(), updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedPrivateEndpointResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName,
                managedPrivateEndpointName, this.innerModel(), updateIfMatch, context)
            .getValue();
        return this;
    }

    ManagedPrivateEndpointResourceImpl(ManagedPrivateEndpointResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.managedVirtualNetworkName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedVirtualNetworks");
        this.managedPrivateEndpointName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedPrivateEndpoints");
    }

    public ManagedPrivateEndpointResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
                localIfNoneMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedPrivateEndpointResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getManagedPrivateEndpoints()
            .getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
                localIfNoneMatch, context)
            .getValue();
        return this;
    }

    public ManagedPrivateEndpointResourceImpl withProperties(ManagedPrivateEndpoint properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public ManagedPrivateEndpointResourceImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
