// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.datafactory.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedPrivateEndpointResourceInner;
import com.azure.resourcemanager.datafactory.models.ManagedPrivateEndpointListResponse;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedPrivateEndpointsClient.
 */
public final class ManagedPrivateEndpointsClientImpl implements ManagedPrivateEndpointsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ManagedPrivateEndpointsService service;

    /**
     * The service client containing this operation class.
     */
    private final DataFactoryManagementClientImpl client;

    /**
     * Initializes an instance of ManagedPrivateEndpointsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ManagedPrivateEndpointsClientImpl(DataFactoryManagementClientImpl client) {
        this.service = RestProxy.create(ManagedPrivateEndpointsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DataFactoryManagementClientManagedPrivateEndpoints to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DataFactoryManagemen")
    public interface ManagedPrivateEndpointsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedPrivateEndpointListResponse>> listByFactory(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("managedVirtualNetworkName") String managedVirtualNetworkName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("managedVirtualNetworkName") String managedVirtualNetworkName,
            @PathParam("managedPrivateEndpointName") String managedPrivateEndpointName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-Match") String ifMatch,
            @BodyParam("application/json") ManagedPrivateEndpointResourceInner managedPrivateEndpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedPrivateEndpointResourceInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("managedVirtualNetworkName") String managedVirtualNetworkName,
            @PathParam("managedPrivateEndpointName") String managedPrivateEndpointName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("managedVirtualNetworkName") String managedVirtualNetworkName,
            @PathParam("managedPrivateEndpointName") String managedPrivateEndpointName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ManagedPrivateEndpointListResponse>> listByFactoryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>>
        listByFactorySinglePageAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, managedVirtualNetworkName, this.client.getApiVersion(), accept,
                context))
            .<PagedResponse<ManagedPrivateEndpointResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactorySinglePageAsync(
        String resourceGroupName, String factoryName, String managedVirtualNetworkName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
                managedVirtualNetworkName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedPrivateEndpointResourceInner> listByFactoryAsync(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName) {
        return new PagedFlux<>(
            () -> listByFactorySinglePageAsync(resourceGroupName, factoryName, managedVirtualNetworkName),
            nextLink -> listByFactoryNextSinglePageAsync(nextLink));
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ManagedPrivateEndpointResourceInner> listByFactoryAsync(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName, Context context) {
        return new PagedFlux<>(
            () -> listByFactorySinglePageAsync(resourceGroupName, factoryName, managedVirtualNetworkName, context),
            nextLink -> listByFactoryNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointResourceInner> listByFactory(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName) {
        return new PagedIterable<>(listByFactoryAsync(resourceGroupName, factoryName, managedVirtualNetworkName));
    }

    /**
     * Lists managed private endpoints.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManagedPrivateEndpointResourceInner> listByFactory(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName, Context context) {
        return new PagedIterable<>(
            listByFactoryAsync(resourceGroupName, factoryName, managedVirtualNetworkName, context));
    }

    /**
     * Creates or updates a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param managedPrivateEndpoint Managed private endpoint resource definition.
     * @param ifMatch ETag of the managed private endpoint entity. Should only be specified for update, for which it
     * should match existing entity or can be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed private endpoint resource type along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String factoryName, String managedVirtualNetworkName,
        String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        if (managedPrivateEndpoint == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpoint is required and cannot be null."));
        } else {
            managedPrivateEndpoint.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
                this.client.getApiVersion(), ifMatch, managedPrivateEndpoint, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param managedPrivateEndpoint Managed private endpoint resource definition.
     * @param ifMatch ETag of the managed private endpoint entity. Should only be specified for update, for which it
     * should match existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed private endpoint resource type along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String factoryName, String managedVirtualNetworkName,
        String managedPrivateEndpointName, ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        if (managedPrivateEndpoint == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpoint is required and cannot be null."));
        } else {
            managedPrivateEndpoint.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifMatch,
            managedPrivateEndpoint, accept, context);
    }

    /**
     * Creates or updates a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param managedPrivateEndpoint Managed private endpoint resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed private endpoint resource type on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName,
        ManagedPrivateEndpointResourceInner managedPrivateEndpoint) {
        final String ifMatch = null;
        return createOrUpdateWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, managedPrivateEndpoint, ifMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param managedPrivateEndpoint Managed private endpoint resource definition.
     * @param ifMatch ETag of the managed private endpoint entity. Should only be specified for update, for which it
     * should match existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed private endpoint resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedPrivateEndpointResourceInner> createOrUpdateWithResponse(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName,
        ManagedPrivateEndpointResourceInner managedPrivateEndpoint, String ifMatch, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, managedPrivateEndpoint, ifMatch, context).block();
    }

    /**
     * Creates or updates a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param managedPrivateEndpoint Managed private endpoint resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed private endpoint resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedPrivateEndpointResourceInner createOrUpdate(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName,
        ManagedPrivateEndpointResourceInner managedPrivateEndpoint) {
        final String ifMatch = null;
        return createOrUpdateWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, managedPrivateEndpoint, ifMatch, Context.NONE).getValue();
    }

    /**
     * Gets a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param ifNoneMatch ETag of the managed private endpoint entity. Should only be specified for get. If the ETag
     * matches the existing entity tag, or if * was provided, then no content will be returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed private endpoint along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> getWithResponseAsync(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
                this.client.getApiVersion(), ifNoneMatch, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param ifNoneMatch ETag of the managed private endpoint entity. Should only be specified for get. If the ETag
     * matches the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed private endpoint along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ManagedPrivateEndpointResourceInner>> getWithResponseAsync(String resourceGroupName,
        String factoryName, String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
            managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), ifNoneMatch, accept,
            context);
    }

    /**
     * Gets a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed private endpoint on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ManagedPrivateEndpointResourceInner> getAsync(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName) {
        final String ifNoneMatch = null;
        return getWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param ifNoneMatch ETag of the managed private endpoint entity. Should only be specified for get. If the ETag
     * matches the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed private endpoint along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ManagedPrivateEndpointResourceInner> getWithResponse(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName, String ifNoneMatch, Context context) {
        return getWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, ifNoneMatch, context).block();
    }

    /**
     * Gets a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed private endpoint.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ManagedPrivateEndpointResourceInner get(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName) {
        final String ifNoneMatch = null;
        return getWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
            ifNoneMatch, Context.NONE).getValue();
    }

    /**
     * Deletes a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (managedVirtualNetworkName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedVirtualNetworkName is required and cannot be null."));
        }
        if (managedPrivateEndpointName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter managedPrivateEndpointName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, managedVirtualNetworkName, managedPrivateEndpointName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String managedVirtualNetworkName,
        String managedPrivateEndpointName) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName,
        String managedVirtualNetworkName, String managedPrivateEndpointName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, managedVirtualNetworkName,
            managedPrivateEndpointName, context).block();
    }

    /**
     * Deletes a managed private endpoint.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param managedVirtualNetworkName Managed virtual network name.
     * @param managedPrivateEndpointName Managed private endpoint name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String managedVirtualNetworkName,
        String managedPrivateEndpointName) {
        deleteWithResponse(resourceGroupName, factoryName, managedVirtualNetworkName, managedPrivateEndpointName,
            Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByFactoryNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ManagedPrivateEndpointResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed private endpoint resources along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedPrivateEndpointResourceInner>> listByFactoryNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByFactoryNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
