// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.CreateRunResponse;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.PipelineResource;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PipelineResourceImpl
    implements PipelineResource, PipelineResource.Definition, PipelineResource.Update {
    private PipelineResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public Map<String, Object> additionalProperties() {
        Map<String, Object> inner = this.innerModel().additionalProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String description() {
        return this.innerModel().description();
    }

    public List<Activity> activities() {
        List<Activity> inner = this.innerModel().activities();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Map<String, ParameterSpecification> parameters() {
        Map<String, ParameterSpecification> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public Map<String, VariableSpecification> variables() {
        Map<String, VariableSpecification> inner = this.innerModel().variables();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public Integer concurrency() {
        return this.innerModel().concurrency();
    }

    public List<Object> annotations() {
        List<Object> inner = this.innerModel().annotations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Map<String, Object> runDimensions() {
        Map<String, Object> inner = this.innerModel().runDimensions();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public PipelineFolder folder() {
        return this.innerModel().folder();
    }

    public PipelinePolicy policy() {
        return this.innerModel().policy();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PipelineResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String pipelineName;

    private String createIfMatch;

    private String updateIfMatch;

    public PipelineResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    public PipelineResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public PipelineResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    PipelineResourceImpl(String name, com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new PipelineResourceInner();
        this.serviceManager = serviceManager;
        this.pipelineName = name;
        this.createIfMatch = null;
    }

    public PipelineResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public PipelineResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, this.innerModel(), updateIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public PipelineResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, this.innerModel(), updateIfMatch,
                context)
            .getValue();
        return this;
    }

    PipelineResourceImpl(PipelineResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.pipelineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "pipelines");
    }

    public PipelineResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .getWithResponse(resourceGroupName, factoryName, pipelineName, localIfNoneMatch, Context.NONE)
            .getValue();
        return this;
    }

    public PipelineResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getPipelines()
            .getWithResponse(resourceGroupName, factoryName, pipelineName, localIfNoneMatch, context)
            .getValue();
        return this;
    }

    public Response<CreateRunResponse> createRunWithResponse(String referencePipelineRunId, Boolean isRecovery,
        String startActivityName, Boolean startFromFailure, Map<String, Object> parameters, Context context) {
        return serviceManager.pipelines()
            .createRunWithResponse(resourceGroupName, factoryName, pipelineName, referencePipelineRunId, isRecovery,
                startActivityName, startFromFailure, parameters, context);
    }

    public CreateRunResponse createRun() {
        return serviceManager.pipelines().createRun(resourceGroupName, factoryName, pipelineName);
    }

    public PipelineResourceImpl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.innerModel().withAdditionalProperties(additionalProperties);
        return this;
    }

    public PipelineResourceImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public PipelineResourceImpl withActivities(List<Activity> activities) {
        this.innerModel().withActivities(activities);
        return this;
    }

    public PipelineResourceImpl withParameters(Map<String, ParameterSpecification> parameters) {
        this.innerModel().withParameters(parameters);
        return this;
    }

    public PipelineResourceImpl withVariables(Map<String, VariableSpecification> variables) {
        this.innerModel().withVariables(variables);
        return this;
    }

    public PipelineResourceImpl withConcurrency(Integer concurrency) {
        this.innerModel().withConcurrency(concurrency);
        return this;
    }

    public PipelineResourceImpl withAnnotations(List<Object> annotations) {
        this.innerModel().withAnnotations(annotations);
        return this;
    }

    public PipelineResourceImpl withRunDimensions(Map<String, Object> runDimensions) {
        this.innerModel().withRunDimensions(runDimensions);
        return this;
    }

    public PipelineResourceImpl withFolder(PipelineFolder folder) {
        this.innerModel().withFolder(folder);
        return this;
    }

    public PipelineResourceImpl withPolicy(PipelinePolicy policy) {
        this.innerModel().withPolicy(policy);
        return this;
    }

    public PipelineResourceImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
