// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.datafactory.fluent.PipelinesClient;
import com.azure.resourcemanager.datafactory.fluent.models.CreateRunResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import com.azure.resourcemanager.datafactory.models.PipelineListResponse;
import java.util.Map;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PipelinesClient.
 */
public final class PipelinesClientImpl implements PipelinesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PipelinesService service;

    /**
     * The service client containing this operation class.
     */
    private final DataFactoryManagementClientImpl client;

    /**
     * Initializes an instance of PipelinesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    PipelinesClientImpl(DataFactoryManagementClientImpl client) {
        this.service
            = RestProxy.create(PipelinesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DataFactoryManagementClientPipelines to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DataFactoryManagemen")
    public interface PipelinesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PipelineListResponse>> listByFactory(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PipelineResourceInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("pipelineName") String pipelineName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-Match") String ifMatch, @BodyParam("application/json") PipelineResourceInner pipeline,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses({ 200, 304 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PipelineResourceInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("pipelineName") String pipelineName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("If-None-Match") String ifNoneMatch, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("pipelineName") String pipelineName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}/createRun")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CreateRunResponseInner>> createRun(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("factoryName") String factoryName,
            @PathParam("pipelineName") String pipelineName, @QueryParam("api-version") String apiVersion,
            @QueryParam("referencePipelineRunId") String referencePipelineRunId,
            @QueryParam("isRecovery") Boolean isRecovery, @QueryParam("startActivityName") String startActivityName,
            @QueryParam("startFromFailure") Boolean startFromFailure,
            @BodyParam("application/json") Map<String, Object> parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PipelineListResponse>> listByFactoryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactorySinglePageAsync(String resourceGroupName,
        String factoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<PipelineResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactorySinglePageAsync(String resourceGroupName,
        String factoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PipelineResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName) {
        return new PagedFlux<>(() -> listByFactorySinglePageAsync(resourceGroupName, factoryName),
            nextLink -> listByFactoryNextSinglePageAsync(nextLink));
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PipelineResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName,
        Context context) {
        return new PagedFlux<>(() -> listByFactorySinglePageAsync(resourceGroupName, factoryName, context),
            nextLink -> listByFactoryNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PipelineResourceInner> listByFactory(String resourceGroupName, String factoryName) {
        return new PagedIterable<>(listByFactoryAsync(resourceGroupName, factoryName));
    }

    /**
     * Lists pipelines.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PipelineResourceInner> listByFactory(String resourceGroupName, String factoryName,
        Context context) {
        return new PagedIterable<>(listByFactoryAsync(resourceGroupName, factoryName, context));
    }

    /**
     * Creates or updates a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param pipeline Pipeline resource definition.
     * @param ifMatch ETag of the pipeline entity. Should only be specified for update, for which it should match
     * existing entity or can be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pipeline resource type along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String factoryName, String pipelineName, PipelineResourceInner pipeline, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        if (pipeline == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipeline is required and cannot be null."));
        } else {
            pipeline.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), ifMatch, pipeline, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param pipeline Pipeline resource definition.
     * @param ifMatch ETag of the pipeline entity. Should only be specified for update, for which it should match
     * existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pipeline resource type along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String factoryName, String pipelineName, PipelineResourceInner pipeline, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        if (pipeline == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipeline is required and cannot be null."));
        } else {
            pipeline.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, pipelineName, this.client.getApiVersion(), ifMatch, pipeline, accept, context);
    }

    /**
     * Creates or updates a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param pipeline Pipeline resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pipeline resource type on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PipelineResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName,
        String pipelineName, PipelineResourceInner pipeline) {
        final String ifMatch = null;
        return createOrUpdateWithResponseAsync(resourceGroupName, factoryName, pipelineName, pipeline, ifMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param pipeline Pipeline resource definition.
     * @param ifMatch ETag of the pipeline entity. Should only be specified for update, for which it should match
     * existing entity or can be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pipeline resource type along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PipelineResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName,
        String pipelineName, PipelineResourceInner pipeline, String ifMatch, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, factoryName, pipelineName, pipeline, ifMatch, context)
            .block();
    }

    /**
     * Creates or updates a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param pipeline Pipeline resource definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pipeline resource type.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PipelineResourceInner createOrUpdate(String resourceGroupName, String factoryName, String pipelineName,
        PipelineResourceInner pipeline) {
        final String ifMatch = null;
        return createOrUpdateWithResponse(resourceGroupName, factoryName, pipelineName, pipeline, ifMatch, Context.NONE)
            .getValue();
    }

    /**
     * Gets a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param ifNoneMatch ETag of the pipeline entity. Should only be specified for get. If the ETag matches the
     * existing entity tag, or if * was provided, then no content will be returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pipeline along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName,
        String pipelineName, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    factoryName, pipelineName, this.client.getApiVersion(), ifNoneMatch, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param ifNoneMatch ETag of the pipeline entity. Should only be specified for get. If the ETag matches the
     * existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pipeline along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PipelineResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName,
        String pipelineName, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName,
            pipelineName, this.client.getApiVersion(), ifNoneMatch, accept, context);
    }

    /**
     * Gets a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pipeline on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PipelineResourceInner> getAsync(String resourceGroupName, String factoryName, String pipelineName) {
        final String ifNoneMatch = null;
        return getWithResponseAsync(resourceGroupName, factoryName, pipelineName, ifNoneMatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param ifNoneMatch ETag of the pipeline entity. Should only be specified for get. If the ETag matches the
     * existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pipeline along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PipelineResourceInner> getWithResponse(String resourceGroupName, String factoryName,
        String pipelineName, String ifNoneMatch, Context context) {
        return getWithResponseAsync(resourceGroupName, factoryName, pipelineName, ifNoneMatch, context).block();
    }

    /**
     * Gets a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pipeline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PipelineResourceInner get(String resourceGroupName, String factoryName, String pipelineName) {
        final String ifNoneMatch = null;
        return getWithResponse(resourceGroupName, factoryName, pipelineName, ifNoneMatch, Context.NONE).getValue();
    }

    /**
     * Deletes a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String pipelineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName,
        String pipelineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, pipelineName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String pipelineName) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, pipelineName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String pipelineName,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, factoryName, pipelineName, context).block();
    }

    /**
     * Deletes a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String pipelineName) {
        deleteWithResponse(resourceGroupName, factoryName, pipelineName, Context.NONE);
    }

    /**
     * Creates a run of a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param referencePipelineRunId The pipeline run identifier. If run ID is specified the parameters of the specified
     * run will be used to create a new run.
     * @param isRecovery Recovery mode flag. If recovery mode is set to true, the specified referenced pipeline run and
     * the new run will be grouped under the same groupId.
     * @param startActivityName In recovery mode, the rerun will start from this activity. If not specified, all
     * activities will run.
     * @param startFromFailure In recovery mode, if set to true, the rerun will start from failed activities. The
     * property will be used only if startActivityName is not specified.
     * @param parameters Parameters of the pipeline run. These parameters will be used only if the runId is not
     * specified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body with a run identifier along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CreateRunResponseInner>> createRunWithResponseAsync(String resourceGroupName,
        String factoryName, String pipelineName, String referencePipelineRunId, Boolean isRecovery,
        String startActivityName, Boolean startFromFailure, Map<String, Object> parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createRun(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, factoryName, pipelineName, this.client.getApiVersion(), referencePipelineRunId,
                isRecovery, startActivityName, startFromFailure, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a run of a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param referencePipelineRunId The pipeline run identifier. If run ID is specified the parameters of the specified
     * run will be used to create a new run.
     * @param isRecovery Recovery mode flag. If recovery mode is set to true, the specified referenced pipeline run and
     * the new run will be grouped under the same groupId.
     * @param startActivityName In recovery mode, the rerun will start from this activity. If not specified, all
     * activities will run.
     * @param startFromFailure In recovery mode, if set to true, the rerun will start from failed activities. The
     * property will be used only if startActivityName is not specified.
     * @param parameters Parameters of the pipeline run. These parameters will be used only if the runId is not
     * specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body with a run identifier along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CreateRunResponseInner>> createRunWithResponseAsync(String resourceGroupName,
        String factoryName, String pipelineName, String referencePipelineRunId, Boolean isRecovery,
        String startActivityName, Boolean startFromFailure, Map<String, Object> parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (pipelineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter pipelineName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRun(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            factoryName, pipelineName, this.client.getApiVersion(), referencePipelineRunId, isRecovery,
            startActivityName, startFromFailure, parameters, accept, context);
    }

    /**
     * Creates a run of a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body with a run identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<CreateRunResponseInner> createRunAsync(String resourceGroupName, String factoryName,
        String pipelineName) {
        final String referencePipelineRunId = null;
        final Boolean isRecovery = null;
        final String startActivityName = null;
        final Boolean startFromFailure = null;
        final Map<String, Object> parameters = null;
        return createRunWithResponseAsync(resourceGroupName, factoryName, pipelineName, referencePipelineRunId,
            isRecovery, startActivityName, startFromFailure, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a run of a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param referencePipelineRunId The pipeline run identifier. If run ID is specified the parameters of the specified
     * run will be used to create a new run.
     * @param isRecovery Recovery mode flag. If recovery mode is set to true, the specified referenced pipeline run and
     * the new run will be grouped under the same groupId.
     * @param startActivityName In recovery mode, the rerun will start from this activity. If not specified, all
     * activities will run.
     * @param startFromFailure In recovery mode, if set to true, the rerun will start from failed activities. The
     * property will be used only if startActivityName is not specified.
     * @param parameters Parameters of the pipeline run. These parameters will be used only if the runId is not
     * specified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body with a run identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CreateRunResponseInner> createRunWithResponse(String resourceGroupName, String factoryName,
        String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName,
        Boolean startFromFailure, Map<String, Object> parameters, Context context) {
        return createRunWithResponseAsync(resourceGroupName, factoryName, pipelineName, referencePipelineRunId,
            isRecovery, startActivityName, startFromFailure, parameters, context).block();
    }

    /**
     * Creates a run of a pipeline.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response body with a run identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CreateRunResponseInner createRun(String resourceGroupName, String factoryName, String pipelineName) {
        final String referencePipelineRunId = null;
        final Boolean isRecovery = null;
        final String startActivityName = null;
        final Boolean startFromFailure = null;
        final Map<String, Object> parameters = null;
        return createRunWithResponse(resourceGroupName, factoryName, pipelineName, referencePipelineRunId, isRecovery,
            startActivityName, startFromFailure, parameters, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByFactoryNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PipelineResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of pipeline resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PipelineResourceInner>> listByFactoryNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByFactoryNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
