// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.PrivateEndPointConnectionsClient;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionResource;
import com.azure.resourcemanager.datafactory.models.PrivateEndPointConnections;

public final class PrivateEndPointConnectionsImpl implements PrivateEndPointConnections {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndPointConnectionsImpl.class);

    private final PrivateEndPointConnectionsClient innerClient;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public PrivateEndPointConnectionsImpl(PrivateEndPointConnectionsClient innerClient,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<PrivateEndpointConnectionResource> listByFactory(String resourceGroupName,
        String factoryName) {
        PagedIterable<PrivateEndpointConnectionResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new PrivateEndpointConnectionResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<PrivateEndpointConnectionResource> listByFactory(String resourceGroupName, String factoryName,
        Context context) {
        PagedIterable<PrivateEndpointConnectionResourceInner> inner
            = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new PrivateEndpointConnectionResourceImpl(inner1, this.manager()));
    }

    private PrivateEndPointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }
}
