// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerResourceInner;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerResource;
import com.azure.resourcemanager.datafactory.models.TriggerSubscriptionOperationStatus;

public final class TriggerResourceImpl implements TriggerResource, TriggerResource.Definition, TriggerResource.Update {
    private TriggerResourceInner innerObject;

    private final com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public Trigger properties() {
        return this.innerModel().properties();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public TriggerResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.datafactory.DataFactoryManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String factoryName;

    private String triggerName;

    private String createIfMatch;

    private String updateIfMatch;

    public TriggerResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    public TriggerResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, triggerName, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public TriggerResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, triggerName, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    TriggerResourceImpl(String name, com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = new TriggerResourceInner();
        this.serviceManager = serviceManager;
        this.triggerName = name;
        this.createIfMatch = null;
    }

    public TriggerResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public TriggerResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, triggerName, this.innerModel(), updateIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public TriggerResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .createOrUpdateWithResponse(resourceGroupName, factoryName, triggerName, this.innerModel(), updateIfMatch,
                context)
            .getValue();
        return this;
    }

    TriggerResourceImpl(TriggerResourceInner innerObject,
        com.azure.resourcemanager.datafactory.DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.triggerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "triggers");
    }

    public TriggerResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .getWithResponse(resourceGroupName, factoryName, triggerName, localIfNoneMatch, Context.NONE)
            .getValue();
        return this;
    }

    public TriggerResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = serviceManager.serviceClient()
            .getTriggers()
            .getWithResponse(resourceGroupName, factoryName, triggerName, localIfNoneMatch, context)
            .getValue();
        return this;
    }

    public TriggerSubscriptionOperationStatus subscribeToEvents() {
        return serviceManager.triggers().subscribeToEvents(resourceGroupName, factoryName, triggerName);
    }

    public TriggerSubscriptionOperationStatus subscribeToEvents(Context context) {
        return serviceManager.triggers().subscribeToEvents(resourceGroupName, factoryName, triggerName, context);
    }

    public Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(Context context) {
        return serviceManager.triggers()
            .getEventSubscriptionStatusWithResponse(resourceGroupName, factoryName, triggerName, context);
    }

    public TriggerSubscriptionOperationStatus getEventSubscriptionStatus() {
        return serviceManager.triggers().getEventSubscriptionStatus(resourceGroupName, factoryName, triggerName);
    }

    public TriggerSubscriptionOperationStatus unsubscribeFromEvents() {
        return serviceManager.triggers().unsubscribeFromEvents(resourceGroupName, factoryName, triggerName);
    }

    public TriggerSubscriptionOperationStatus unsubscribeFromEvents(Context context) {
        return serviceManager.triggers().unsubscribeFromEvents(resourceGroupName, factoryName, triggerName, context);
    }

    public void start() {
        serviceManager.triggers().start(resourceGroupName, factoryName, triggerName);
    }

    public void start(Context context) {
        serviceManager.triggers().start(resourceGroupName, factoryName, triggerName, context);
    }

    public void stop() {
        serviceManager.triggers().stop(resourceGroupName, factoryName, triggerName);
    }

    public void stop(Context context) {
        serviceManager.triggers().stop(resourceGroupName, factoryName, triggerName, context);
    }

    public TriggerResourceImpl withProperties(Trigger properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public TriggerResourceImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
