// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.resourcemanager.datafactory.fluent.models.AccessPolicyResponseInner;

/**
 * An immutable client-side representation of AccessPolicyResponse.
 */
public interface AccessPolicyResponse {
    /**
     * Gets the policy property: The user access policy.
     * 
     * @return the policy value.
     */
    UserAccessPolicy policy();

    /**
     * Gets the accessToken property: Data Plane read only access token.
     * 
     * @return the accessToken value.
     */
    String accessToken();

    /**
     * Gets the dataPlaneUrl property: Data Plane service base URL.
     * 
     * @return the dataPlaneUrl value.
     */
    String dataPlaneUrl();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.AccessPolicyResponseInner object.
     * 
     * @return the inner object.
     */
    AccessPolicyResponseInner innerModel();
}
