// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A pipeline activity.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = Activity.class, visible = true)
@JsonTypeName("Activity")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Container", value = ControlActivity.class),
    @JsonSubTypes.Type(name = "Execution", value = ExecutionActivity.class),
    @JsonSubTypes.Type(name = "ExecuteWranglingDataflow", value = ExecuteWranglingDataflowActivity.class) })
@Fluent
public class Activity {
    /*
     * Type of activity.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type;

    /*
     * Activity name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Activity description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JsonProperty(value = "state")
    private ActivityState state;

    /*
     * Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JsonProperty(value = "onInactiveMarkAs")
    private ActivityOnInactiveMarkAs onInactiveMarkAs;

    /*
     * Activity depends on condition.
     */
    @JsonProperty(value = "dependsOn")
    private List<ActivityDependency> dependsOn;

    /*
     * Activity user properties.
     */
    @JsonProperty(value = "userProperties")
    private List<UserProperty> userProperties;

    /*
     * A pipeline activity.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of Activity class.
     */
    public Activity() {
        this.type = "Activity";
    }

    /**
     * Get the type property: Type of activity.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: Activity name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Activity name.
     * 
     * @param name the name value to set.
     * @return the Activity object itself.
     */
    public Activity withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Activity description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Activity description.
     * 
     * @param description the description value to set.
     * @return the Activity object itself.
     */
    public Activity withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the state property: Activity state. This is an optional property and if not provided, the state will be
     * Active by default.
     * 
     * @return the state value.
     */
    public ActivityState state() {
        return this.state;
    }

    /**
     * Set the state property: Activity state. This is an optional property and if not provided, the state will be
     * Active by default.
     * 
     * @param state the state value to set.
     * @return the Activity object itself.
     */
    public Activity withState(ActivityState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the onInactiveMarkAs property: Status result of the activity when the state is set to Inactive. This is an
     * optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     * 
     * @return the onInactiveMarkAs value.
     */
    public ActivityOnInactiveMarkAs onInactiveMarkAs() {
        return this.onInactiveMarkAs;
    }

    /**
     * Set the onInactiveMarkAs property: Status result of the activity when the state is set to Inactive. This is an
     * optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     * 
     * @param onInactiveMarkAs the onInactiveMarkAs value to set.
     * @return the Activity object itself.
     */
    public Activity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        this.onInactiveMarkAs = onInactiveMarkAs;
        return this;
    }

    /**
     * Get the dependsOn property: Activity depends on condition.
     * 
     * @return the dependsOn value.
     */
    public List<ActivityDependency> dependsOn() {
        return this.dependsOn;
    }

    /**
     * Set the dependsOn property: Activity depends on condition.
     * 
     * @param dependsOn the dependsOn value to set.
     * @return the Activity object itself.
     */
    public Activity withDependsOn(List<ActivityDependency> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    /**
     * Get the userProperties property: Activity user properties.
     * 
     * @return the userProperties value.
     */
    public List<UserProperty> userProperties() {
        return this.userProperties;
    }

    /**
     * Set the userProperties property: Activity user properties.
     * 
     * @param userProperties the userProperties value to set.
     * @return the Activity object itself.
     */
    public Activity withUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: A pipeline activity.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: A pipeline activity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the Activity object itself.
     */
    public Activity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model Activity"));
        }
        if (dependsOn() != null) {
            dependsOn().forEach(e -> e.validate());
        }
        if (userProperties() != null) {
            userProperties().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Activity.class);
}
