// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Activity dependency information.
 */
@Fluent
public final class ActivityDependency {
    /*
     * Activity name.
     */
    @JsonProperty(value = "activity", required = true)
    private String activity;

    /*
     * Match-Condition for the dependency.
     */
    @JsonProperty(value = "dependencyConditions", required = true)
    private List<DependencyCondition> dependencyConditions;

    /*
     * Activity dependency information.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ActivityDependency class.
     */
    public ActivityDependency() {
    }

    /**
     * Get the activity property: Activity name.
     * 
     * @return the activity value.
     */
    public String activity() {
        return this.activity;
    }

    /**
     * Set the activity property: Activity name.
     * 
     * @param activity the activity value to set.
     * @return the ActivityDependency object itself.
     */
    public ActivityDependency withActivity(String activity) {
        this.activity = activity;
        return this;
    }

    /**
     * Get the dependencyConditions property: Match-Condition for the dependency.
     * 
     * @return the dependencyConditions value.
     */
    public List<DependencyCondition> dependencyConditions() {
        return this.dependencyConditions;
    }

    /**
     * Set the dependencyConditions property: Match-Condition for the dependency.
     * 
     * @param dependencyConditions the dependencyConditions value to set.
     * @return the ActivityDependency object itself.
     */
    public ActivityDependency withDependencyConditions(List<DependencyCondition> dependencyConditions) {
        this.dependencyConditions = dependencyConditions;
        return this;
    }

    /**
     * Get the additionalProperties property: Activity dependency information.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Activity dependency information.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ActivityDependency object itself.
     */
    public ActivityDependency withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (activity() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property activity in model ActivityDependency"));
        }
        if (dependencyConditions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property dependencyConditions in model ActivityDependency"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActivityDependency.class);
}
