// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonRdsForSqlServerLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Amazon RDS for SQL Server linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AmazonRdsForSqlServerLinkedService.class,
    visible = true)
@JsonTypeName("AmazonRdsForSqlServer")
@Fluent
public final class AmazonRdsForSqlServerLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AmazonRdsForSqlServer";

    /*
     * Amazon RDS for SQL Server linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AmazonRdsForSqlServerLinkedServiceTypeProperties innerTypeProperties
        = new AmazonRdsForSqlServerLinkedServiceTypeProperties();

    /**
     * Creates an instance of AmazonRdsForSqlServerLinkedService class.
     */
    public AmazonRdsForSqlServerLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Amazon RDS for SQL Server linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AmazonRdsForSqlServerLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonRdsForSqlServerLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonRdsForSqlServerLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonRdsForSqlServerLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonRdsForSqlServerLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    /**
     * Set the connectionString property: The connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the AmazonRdsForSqlServerLinkedService object itself.
     */
    public AmazonRdsForSqlServerLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the username property: The on-premises Windows authentication user name. Type: string (or Expression with
     * resultType string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: The on-premises Windows authentication user name. Type: string (or Expression with
     * resultType string).
     * 
     * @param username the username value to set.
     * @return the AmazonRdsForSqlServerLinkedService object itself.
     */
    public AmazonRdsForSqlServerLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: The on-premises Windows authentication password.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The on-premises Windows authentication password.
     * 
     * @param password the password value to set.
     * @return the AmazonRdsForSqlServerLinkedService object itself.
     */
    public AmazonRdsForSqlServerLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AmazonRdsForSqlServerLinkedService object itself.
     */
    public AmazonRdsForSqlServerLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Get the alwaysEncryptedSettings property: Sql always encrypted properties.
     * 
     * @return the alwaysEncryptedSettings value.
     */
    public SqlAlwaysEncryptedProperties alwaysEncryptedSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().alwaysEncryptedSettings();
    }

    /**
     * Set the alwaysEncryptedSettings property: Sql always encrypted properties.
     * 
     * @param alwaysEncryptedSettings the alwaysEncryptedSettings value to set.
     * @return the AmazonRdsForSqlServerLinkedService object itself.
     */
    public AmazonRdsForSqlServerLinkedService
        withAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonRdsForSqlServerLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAlwaysEncryptedSettings(alwaysEncryptedSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AmazonRdsForSqlServerLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AmazonRdsForSqlServerLinkedService.class);
}
