// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonS3DatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AmazonS3Dataset.class, visible = true)
@JsonTypeName("AmazonS3Object")
@Fluent
public final class AmazonS3Dataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AmazonS3Object";

    /*
     * Amazon S3 dataset properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AmazonS3DatasetTypeProperties innerTypeProperties = new AmazonS3DatasetTypeProperties();

    /**
     * Creates an instance of AmazonS3Dataset class.
     */
    public AmazonS3Dataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Amazon S3 dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AmazonS3DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AmazonS3Dataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the bucketName property: The name of the Amazon S3 bucket. Type: string (or Expression with resultType
     * string).
     * 
     * @return the bucketName value.
     */
    public Object bucketName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().bucketName();
    }

    /**
     * Set the bucketName property: The name of the Amazon S3 bucket. Type: string (or Expression with resultType
     * string).
     * 
     * @param bucketName the bucketName value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withBucketName(Object bucketName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withBucketName(bucketName);
        return this;
    }

    /**
     * Get the key property: The key of the Amazon S3 object. Type: string (or Expression with resultType string).
     * 
     * @return the key value.
     */
    public Object key() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().key();
    }

    /**
     * Set the key property: The key of the Amazon S3 object. Type: string (or Expression with resultType string).
     * 
     * @param key the key value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withKey(Object key) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withKey(key);
        return this;
    }

    /**
     * Get the prefix property: The prefix filter for the S3 object name. Type: string (or Expression with resultType
     * string).
     * 
     * @return the prefix value.
     */
    public Object prefix() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().prefix();
    }

    /**
     * Set the prefix property: The prefix filter for the S3 object name. Type: string (or Expression with resultType
     * string).
     * 
     * @param prefix the prefix value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withPrefix(Object prefix) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withPrefix(prefix);
        return this;
    }

    /**
     * Get the version property: The version for the S3 object. Type: string (or Expression with resultType string).
     * 
     * @return the version value.
     */
    public Object version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    /**
     * Set the version property: The version for the S3 object. Type: string (or Expression with resultType string).
     * 
     * @param version the version value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withVersion(Object version) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withVersion(version);
        return this;
    }

    /**
     * Get the modifiedDatetimeStart property: The start of S3 object's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @return the modifiedDatetimeStart value.
     */
    public Object modifiedDatetimeStart() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeStart();
    }

    /**
     * Set the modifiedDatetimeStart property: The start of S3 object's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @param modifiedDatetimeStart the modifiedDatetimeStart value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeStart(modifiedDatetimeStart);
        return this;
    }

    /**
     * Get the modifiedDatetimeEnd property: The end of S3 object's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @return the modifiedDatetimeEnd value.
     */
    public Object modifiedDatetimeEnd() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeEnd();
    }

    /**
     * Set the modifiedDatetimeEnd property: The end of S3 object's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @param modifiedDatetimeEnd the modifiedDatetimeEnd value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeEnd(modifiedDatetimeEnd);
        return this;
    }

    /**
     * Get the format property: The format of files.
     * 
     * @return the format value.
     */
    public DatasetStorageFormat format() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().format();
    }

    /**
     * Set the format property: The format of files.
     * 
     * @param format the format value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withFormat(DatasetStorageFormat format) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withFormat(format);
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the Amazon S3 object.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    /**
     * Set the compression property: The data compression method used for the Amazon S3 object.
     * 
     * @param compression the compression value to set.
     * @return the AmazonS3Dataset object itself.
     */
    public AmazonS3Dataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AmazonS3Dataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AmazonS3Dataset.class);
}
