// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AppFiguresLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Linked service for AppFigures.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AppFiguresLinkedService.class,
    visible = true)
@JsonTypeName("AppFigures")
@Fluent
public final class AppFiguresLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AppFigures";

    /*
     * AppFigures linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AppFiguresLinkedServiceTypeProperties innerTypeProperties = new AppFiguresLinkedServiceTypeProperties();

    /**
     * Creates an instance of AppFiguresLinkedService class.
     */
    public AppFiguresLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: AppFigures linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AppFiguresLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppFiguresLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppFiguresLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppFiguresLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppFiguresLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the username property: The username of the Appfigures source. Type: string (or Expression with resultType
     * string).
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: The username of the Appfigures source. Type: string (or Expression with resultType
     * string).
     * 
     * @param username the username value to set.
     * @return the AppFiguresLinkedService object itself.
     */
    public AppFiguresLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AppFiguresLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: The password of the AppFigures source.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The password of the AppFigures source.
     * 
     * @param password the password value to set.
     * @return the AppFiguresLinkedService object itself.
     */
    public AppFiguresLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AppFiguresLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the clientKey property: The client key for the AppFigures source.
     * 
     * @return the clientKey value.
     */
    public SecretBase clientKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientKey();
    }

    /**
     * Set the clientKey property: The client key for the AppFigures source.
     * 
     * @param clientKey the clientKey value to set.
     * @return the AppFiguresLinkedService object itself.
     */
    public AppFiguresLinkedService withClientKey(SecretBase clientKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AppFiguresLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientKey(clientKey);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AppFiguresLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AppFiguresLinkedService.class);
}
