// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The data stored in Avro format.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AvroFormat.class, visible = true)
@JsonTypeName("AvroFormat")
@Fluent
public final class AvroFormat extends DatasetStorageFormat {
    /*
     * Type of dataset storage format.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AvroFormat";

    /**
     * Creates an instance of AvroFormat class.
     */
    public AvroFormat() {
    }

    /**
     * Get the type property: Type of dataset storage format.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AvroFormat withSerializer(Object serializer) {
        super.withSerializer(serializer);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AvroFormat withDeserializer(Object deserializer) {
        super.withDeserializer(deserializer);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
