// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Avro write settings.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AvroWriteSettings.class, visible = true)
@JsonTypeName("AvroWriteSettings")
@Fluent
public final class AvroWriteSettings extends FormatWriteSettings {
    /*
     * The write setting type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AvroWriteSettings";

    /*
     * Top level record name in write result, which is required in AVRO spec.
     */
    @JsonProperty(value = "recordName")
    private String recordName;

    /*
     * Record namespace in the write result.
     */
    @JsonProperty(value = "recordNamespace")
    private String recordNamespace;

    /*
     * Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "maxRowsPerFile")
    private Object maxRowsPerFile;

    /*
     * Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "fileNamePrefix")
    private Object fileNamePrefix;

    /**
     * Creates an instance of AvroWriteSettings class.
     */
    public AvroWriteSettings() {
    }

    /**
     * Get the type property: The write setting type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the recordName property: Top level record name in write result, which is required in AVRO spec.
     * 
     * @return the recordName value.
     */
    public String recordName() {
        return this.recordName;
    }

    /**
     * Set the recordName property: Top level record name in write result, which is required in AVRO spec.
     * 
     * @param recordName the recordName value to set.
     * @return the AvroWriteSettings object itself.
     */
    public AvroWriteSettings withRecordName(String recordName) {
        this.recordName = recordName;
        return this;
    }

    /**
     * Get the recordNamespace property: Record namespace in the write result.
     * 
     * @return the recordNamespace value.
     */
    public String recordNamespace() {
        return this.recordNamespace;
    }

    /**
     * Set the recordNamespace property: Record namespace in the write result.
     * 
     * @param recordNamespace the recordNamespace value to set.
     * @return the AvroWriteSettings object itself.
     */
    public AvroWriteSettings withRecordNamespace(String recordNamespace) {
        this.recordNamespace = recordNamespace;
        return this;
    }

    /**
     * Get the maxRowsPerFile property: Limit the written file's row count to be smaller than or equal to the specified
     * count. Type: integer (or Expression with resultType integer).
     * 
     * @return the maxRowsPerFile value.
     */
    public Object maxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    /**
     * Set the maxRowsPerFile property: Limit the written file's row count to be smaller than or equal to the specified
     * count. Type: integer (or Expression with resultType integer).
     * 
     * @param maxRowsPerFile the maxRowsPerFile value to set.
     * @return the AvroWriteSettings object itself.
     */
    public AvroWriteSettings withMaxRowsPerFile(Object maxRowsPerFile) {
        this.maxRowsPerFile = maxRowsPerFile;
        return this;
    }

    /**
     * Get the fileNamePrefix property: Specifies the file name pattern
     * &lt;fileNamePrefix&gt;_&lt;fileIndex&gt;.&lt;fileExtension&gt; when copy from non-file based store without
     * partitionOptions. Type: string (or Expression with resultType string).
     * 
     * @return the fileNamePrefix value.
     */
    public Object fileNamePrefix() {
        return this.fileNamePrefix;
    }

    /**
     * Set the fileNamePrefix property: Specifies the file name pattern
     * &lt;fileNamePrefix&gt;_&lt;fileIndex&gt;.&lt;fileExtension&gt; when copy from non-file based store without
     * partitionOptions. Type: string (or Expression with resultType string).
     * 
     * @param fileNamePrefix the fileNamePrefix value to set.
     * @return the AvroWriteSettings object itself.
     */
    public AvroWriteSettings withFileNamePrefix(Object fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
