// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.AzureBlobDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The Azure Blob storage.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AzureBlobDataset.class, visible = true)
@JsonTypeName("AzureBlob")
@Fluent
public final class AzureBlobDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureBlob";

    /*
     * Azure Blob dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private AzureBlobDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of AzureBlobDataset class.
     */
    public AzureBlobDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Azure Blob dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AzureBlobDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureBlobDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the folderPath property: The path of the Azure Blob storage. Type: string (or Expression with resultType
     * string).
     * 
     * @return the folderPath value.
     */
    public Object folderPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().folderPath();
    }

    /**
     * Set the folderPath property: The path of the Azure Blob storage. Type: string (or Expression with resultType
     * string).
     * 
     * @param folderPath the folderPath value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withFolderPath(Object folderPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withFolderPath(folderPath);
        return this;
    }

    /**
     * Get the tableRootLocation property: The root of blob path. Type: string (or Expression with resultType string).
     * 
     * @return the tableRootLocation value.
     */
    public Object tableRootLocation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableRootLocation();
    }

    /**
     * Set the tableRootLocation property: The root of blob path. Type: string (or Expression with resultType string).
     * 
     * @param tableRootLocation the tableRootLocation value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withTableRootLocation(Object tableRootLocation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withTableRootLocation(tableRootLocation);
        return this;
    }

    /**
     * Get the fileName property: The name of the Azure Blob. Type: string (or Expression with resultType string).
     * 
     * @return the fileName value.
     */
    public Object fileName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileName();
    }

    /**
     * Set the fileName property: The name of the Azure Blob. Type: string (or Expression with resultType string).
     * 
     * @param fileName the fileName value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withFileName(Object fileName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withFileName(fileName);
        return this;
    }

    /**
     * Get the modifiedDatetimeStart property: The start of Azure Blob's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @return the modifiedDatetimeStart value.
     */
    public Object modifiedDatetimeStart() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeStart();
    }

    /**
     * Set the modifiedDatetimeStart property: The start of Azure Blob's modified datetime. Type: string (or Expression
     * with resultType string).
     * 
     * @param modifiedDatetimeStart the modifiedDatetimeStart value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeStart(modifiedDatetimeStart);
        return this;
    }

    /**
     * Get the modifiedDatetimeEnd property: The end of Azure Blob's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @return the modifiedDatetimeEnd value.
     */
    public Object modifiedDatetimeEnd() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeEnd();
    }

    /**
     * Set the modifiedDatetimeEnd property: The end of Azure Blob's modified datetime. Type: string (or Expression with
     * resultType string).
     * 
     * @param modifiedDatetimeEnd the modifiedDatetimeEnd value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeEnd(modifiedDatetimeEnd);
        return this;
    }

    /**
     * Get the format property: The format of the Azure Blob storage.
     * 
     * @return the format value.
     */
    public DatasetStorageFormat format() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().format();
    }

    /**
     * Set the format property: The format of the Azure Blob storage.
     * 
     * @param format the format value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withFormat(DatasetStorageFormat format) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withFormat(format);
        return this;
    }

    /**
     * Get the compression property: The data compression method used for the blob storage.
     * 
     * @return the compression value.
     */
    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    /**
     * Set the compression property: The data compression method used for the blob storage.
     * 
     * @param compression the compression value to set.
     * @return the AzureBlobDataset object itself.
     */
    public AzureBlobDataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBlobDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
