// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Azure Data Explorer sink.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AzureDataExplorerSink.class, visible = true)
@JsonTypeName("AzureDataExplorerSink")
@Fluent
public final class AzureDataExplorerSink extends CopySink {
    /*
     * Copy sink type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureDataExplorerSink";

    /*
     * A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
     */
    @JsonProperty(value = "ingestionMappingName")
    private Object ingestionMappingName;

    /*
     * An explicit column mapping description provided in a json format. Type: string.
     */
    @JsonProperty(value = "ingestionMappingAsJson")
    private Object ingestionMappingAsJson;

    /*
     * If set to true, any aggregation will be skipped. Default is false. Type: boolean.
     */
    @JsonProperty(value = "flushImmediately")
    private Object flushImmediately;

    /**
     * Creates an instance of AzureDataExplorerSink class.
     */
    public AzureDataExplorerSink() {
    }

    /**
     * Get the type property: Copy sink type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the ingestionMappingName property: A name of a pre-created csv mapping that was defined on the target Kusto
     * table. Type: string.
     * 
     * @return the ingestionMappingName value.
     */
    public Object ingestionMappingName() {
        return this.ingestionMappingName;
    }

    /**
     * Set the ingestionMappingName property: A name of a pre-created csv mapping that was defined on the target Kusto
     * table. Type: string.
     * 
     * @param ingestionMappingName the ingestionMappingName value to set.
     * @return the AzureDataExplorerSink object itself.
     */
    public AzureDataExplorerSink withIngestionMappingName(Object ingestionMappingName) {
        this.ingestionMappingName = ingestionMappingName;
        return this;
    }

    /**
     * Get the ingestionMappingAsJson property: An explicit column mapping description provided in a json format. Type:
     * string.
     * 
     * @return the ingestionMappingAsJson value.
     */
    public Object ingestionMappingAsJson() {
        return this.ingestionMappingAsJson;
    }

    /**
     * Set the ingestionMappingAsJson property: An explicit column mapping description provided in a json format. Type:
     * string.
     * 
     * @param ingestionMappingAsJson the ingestionMappingAsJson value to set.
     * @return the AzureDataExplorerSink object itself.
     */
    public AzureDataExplorerSink withIngestionMappingAsJson(Object ingestionMappingAsJson) {
        this.ingestionMappingAsJson = ingestionMappingAsJson;
        return this;
    }

    /**
     * Get the flushImmediately property: If set to true, any aggregation will be skipped. Default is false. Type:
     * boolean.
     * 
     * @return the flushImmediately value.
     */
    public Object flushImmediately() {
        return this.flushImmediately;
    }

    /**
     * Set the flushImmediately property: If set to true, any aggregation will be skipped. Default is false. Type:
     * boolean.
     * 
     * @param flushImmediately the flushImmediately value to set.
     * @return the AzureDataExplorerSink object itself.
     */
    public AzureDataExplorerSink withFlushImmediately(Object flushImmediately) {
        this.flushImmediately = flushImmediately;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataExplorerSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
