// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureDataLakeAnalyticsLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Azure Data Lake Analytics linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AzureDataLakeAnalyticsLinkedService.class,
    visible = true)
@JsonTypeName("AzureDataLakeAnalytics")
@Fluent
public final class AzureDataLakeAnalyticsLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureDataLakeAnalytics";

    /*
     * Azure Data Lake Analytics linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AzureDataLakeAnalyticsLinkedServiceTypeProperties innerTypeProperties
        = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();

    /**
     * Creates an instance of AzureDataLakeAnalyticsLinkedService class.
     */
    public AzureDataLakeAnalyticsLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Azure Data Lake Analytics linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AzureDataLakeAnalyticsLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataLakeAnalyticsLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataLakeAnalyticsLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataLakeAnalyticsLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDataLakeAnalyticsLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the accountName property: The Azure Data Lake Analytics account name. Type: string (or Expression with
     * resultType string).
     * 
     * @return the accountName value.
     */
    public Object accountName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountName();
    }

    /**
     * Set the accountName property: The Azure Data Lake Analytics account name. Type: string (or Expression with
     * resultType string).
     * 
     * @param accountName the accountName value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withAccountName(Object accountName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountName(accountName);
        return this;
    }

    /**
     * Get the servicePrincipalId property: The ID of the application used to authenticate against the Azure Data Lake
     * Analytics account. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    /**
     * Set the servicePrincipalId property: The ID of the application used to authenticate against the Azure Data Lake
     * Analytics account. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The Key of the application used to authenticate against the Azure Data Lake
     * Analytics account.
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    /**
     * Set the servicePrincipalKey property: The Key of the application used to authenticate against the Azure Data Lake
     * Analytics account.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    /**
     * Get the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    /**
     * Set the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    /**
     * Get the subscriptionId property: Data Lake Analytics account subscription ID (if different from Data Factory
     * account). Type: string (or Expression with resultType string).
     * 
     * @return the subscriptionId value.
     */
    public Object subscriptionId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().subscriptionId();
    }

    /**
     * Set the subscriptionId property: Data Lake Analytics account subscription ID (if different from Data Factory
     * account). Type: string (or Expression with resultType string).
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withSubscriptionId(Object subscriptionId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSubscriptionId(subscriptionId);
        return this;
    }

    /**
     * Get the resourceGroupName property: Data Lake Analytics account resource group name (if different from Data
     * Factory account). Type: string (or Expression with resultType string).
     * 
     * @return the resourceGroupName value.
     */
    public Object resourceGroupName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resourceGroupName();
    }

    /**
     * Set the resourceGroupName property: Data Lake Analytics account resource group name (if different from Data
     * Factory account). Type: string (or Expression with resultType string).
     * 
     * @param resourceGroupName the resourceGroupName value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withResourceGroupName(Object resourceGroupName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withResourceGroupName(resourceGroupName);
        return this;
    }

    /**
     * Get the dataLakeAnalyticsUri property: Azure Data Lake Analytics URI Type: string (or Expression with resultType
     * string).
     * 
     * @return the dataLakeAnalyticsUri value.
     */
    public Object dataLakeAnalyticsUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataLakeAnalyticsUri();
    }

    /**
     * Set the dataLakeAnalyticsUri property: Azure Data Lake Analytics URI Type: string (or Expression with resultType
     * string).
     * 
     * @param dataLakeAnalyticsUri the dataLakeAnalyticsUri value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withDataLakeAnalyticsUri(Object dataLakeAnalyticsUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDataLakeAnalyticsUri(dataLakeAnalyticsUri);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureDataLakeAnalyticsLinkedService object itself.
     */
    public AzureDataLakeAnalyticsLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AzureDataLakeAnalyticsLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureDataLakeAnalyticsLinkedService.class);
}
