// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Azure Databricks Delta Lake sink.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AzureDatabricksDeltaLakeSink.class,
    visible = true)
@JsonTypeName("AzureDatabricksDeltaLakeSink")
@Fluent
public final class AzureDatabricksDeltaLakeSink extends CopySink {
    /*
     * Copy sink type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureDatabricksDeltaLakeSink";

    /*
     * SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "preCopyScript")
    private Object preCopyScript;

    /*
     * Azure Databricks Delta Lake import settings.
     */
    @JsonProperty(value = "importSettings")
    private AzureDatabricksDeltaLakeImportCommand importSettings;

    /**
     * Creates an instance of AzureDatabricksDeltaLakeSink class.
     */
    public AzureDatabricksDeltaLakeSink() {
    }

    /**
     * Get the type property: Copy sink type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the preCopyScript property: SQL pre-copy script. Type: string (or Expression with resultType string).
     * 
     * @return the preCopyScript value.
     */
    public Object preCopyScript() {
        return this.preCopyScript;
    }

    /**
     * Set the preCopyScript property: SQL pre-copy script. Type: string (or Expression with resultType string).
     * 
     * @param preCopyScript the preCopyScript value to set.
     * @return the AzureDatabricksDeltaLakeSink object itself.
     */
    public AzureDatabricksDeltaLakeSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    /**
     * Get the importSettings property: Azure Databricks Delta Lake import settings.
     * 
     * @return the importSettings value.
     */
    public AzureDatabricksDeltaLakeImportCommand importSettings() {
        return this.importSettings;
    }

    /**
     * Set the importSettings property: Azure Databricks Delta Lake import settings.
     * 
     * @param importSettings the importSettings value to set.
     * @return the AzureDatabricksDeltaLakeSink object itself.
     */
    public AzureDatabricksDeltaLakeSink withImportSettings(AzureDatabricksDeltaLakeImportCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureDatabricksDeltaLakeSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (importSettings() != null) {
            importSettings().validate();
        }
    }
}
