// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureFileStorageLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Azure File Storage linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AzureFileStorageLinkedService.class,
    visible = true)
@JsonTypeName("AzureFileStorage")
@Fluent
public final class AzureFileStorageLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureFileStorage";

    /*
     * Azure File Storage linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AzureFileStorageLinkedServiceTypeProperties innerTypeProperties
        = new AzureFileStorageLinkedServiceTypeProperties();

    /**
     * Creates an instance of AzureFileStorageLinkedService class.
     */
    public AzureFileStorageLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Azure File Storage linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AzureFileStorageLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureFileStorageLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureFileStorageLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureFileStorageLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureFileStorageLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the host property: Host name of the server. Type: string (or Expression with resultType string).
     * 
     * @return the host value.
     */
    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    /**
     * Set the host property: Host name of the server. Type: string (or Expression with resultType string).
     * 
     * @param host the host value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    /**
     * Get the userId property: User ID to logon the server. Type: string (or Expression with resultType string).
     * 
     * @return the userId value.
     */
    public Object userId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().userId();
    }

    /**
     * Set the userId property: User ID to logon the server. Type: string (or Expression with resultType string).
     * 
     * @param userId the userId value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withUserId(Object userId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUserId(userId);
        return this;
    }

    /**
     * Get the password property: Password to logon the server.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: Password to logon the server.
     * 
     * @param password the password value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Get the connectionString property: The connection string. It is mutually exclusive with sasUri property. Type:
     * string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    /**
     * Set the connectionString property: The connection string. It is mutually exclusive with sasUri property. Type:
     * string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the accountKey property: The Azure key vault secret reference of accountKey in connection string.
     * 
     * @return the accountKey value.
     */
    public AzureKeyVaultSecretReference accountKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountKey();
    }

    /**
     * Set the accountKey property: The Azure key vault secret reference of accountKey in connection string.
     * 
     * @param accountKey the accountKey value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withAccountKey(AzureKeyVaultSecretReference accountKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountKey(accountKey);
        return this;
    }

    /**
     * Get the sasUri property: SAS URI of the Azure File resource. It is mutually exclusive with connectionString
     * property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the sasUri value.
     */
    public Object sasUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasUri();
    }

    /**
     * Set the sasUri property: SAS URI of the Azure File resource. It is mutually exclusive with connectionString
     * property. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param sasUri the sasUri value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withSasUri(Object sasUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasUri(sasUri);
        return this;
    }

    /**
     * Get the sasToken property: The Azure key vault secret reference of sasToken in sas uri.
     * 
     * @return the sasToken value.
     */
    public AzureKeyVaultSecretReference sasToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasToken();
    }

    /**
     * Set the sasToken property: The Azure key vault secret reference of sasToken in sas uri.
     * 
     * @param sasToken the sasToken value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withSasToken(AzureKeyVaultSecretReference sasToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasToken(sasToken);
        return this;
    }

    /**
     * Get the fileShare property: The azure file share name. It is required when auth with accountKey/sasToken. Type:
     * string (or Expression with resultType string).
     * 
     * @return the fileShare value.
     */
    public Object fileShare() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileShare();
    }

    /**
     * Set the fileShare property: The azure file share name. It is required when auth with accountKey/sasToken. Type:
     * string (or Expression with resultType string).
     * 
     * @param fileShare the fileShare value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withFileShare(Object fileShare) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFileShare(fileShare);
        return this;
    }

    /**
     * Get the snapshot property: The azure file share snapshot version. Type: string (or Expression with resultType
     * string).
     * 
     * @return the snapshot value.
     */
    public Object snapshot() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().snapshot();
    }

    /**
     * Set the snapshot property: The azure file share snapshot version. Type: string (or Expression with resultType
     * string).
     * 
     * @param snapshot the snapshot value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withSnapshot(Object snapshot) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSnapshot(snapshot);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureFileStorageLinkedService object itself.
     */
    public AzureFileStorageLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AzureFileStorageLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureFileStorageLinkedService.class);
}
