// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The list of HTTP methods supported by a AzureFunctionActivity.
 */
public final class AzureFunctionActivityMethod extends ExpandableStringEnum<AzureFunctionActivityMethod> {
    /**
     * Static value GET for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod GET = fromString("GET");

    /**
     * Static value POST for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod POST = fromString("POST");

    /**
     * Static value PUT for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod PUT = fromString("PUT");

    /**
     * Static value DELETE for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod DELETE = fromString("DELETE");

    /**
     * Static value OPTIONS for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod OPTIONS = fromString("OPTIONS");

    /**
     * Static value HEAD for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod HEAD = fromString("HEAD");

    /**
     * Static value TRACE for AzureFunctionActivityMethod.
     */
    public static final AzureFunctionActivityMethod TRACE = fromString("TRACE");

    /**
     * Creates a new instance of AzureFunctionActivityMethod value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureFunctionActivityMethod() {
    }

    /**
     * Creates or finds a AzureFunctionActivityMethod from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AzureFunctionActivityMethod.
     */
    @JsonCreator
    public static AzureFunctionActivityMethod fromString(String name) {
        return fromString(name, AzureFunctionActivityMethod.class);
    }

    /**
     * Gets known AzureFunctionActivityMethod values.
     * 
     * @return known AzureFunctionActivityMethod values.
     */
    public static Collection<AzureFunctionActivityMethod> values() {
        return values(AzureFunctionActivityMethod.class);
    }
}
