// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureKeyVaultLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Azure Key Vault linked service.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = AzureKeyVaultLinkedService.class,
    visible = true)
@JsonTypeName("AzureKeyVault")
@Fluent
public final class AzureKeyVaultLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureKeyVault";

    /*
     * Azure Key Vault linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AzureKeyVaultLinkedServiceTypeProperties innerTypeProperties
        = new AzureKeyVaultLinkedServiceTypeProperties();

    /**
     * Creates an instance of AzureKeyVaultLinkedService class.
     */
    public AzureKeyVaultLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Azure Key Vault linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AzureKeyVaultLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureKeyVaultLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureKeyVaultLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureKeyVaultLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureKeyVaultLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the baseUrl property: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string
     * (or Expression with resultType string).
     * 
     * @return the baseUrl value.
     */
    public Object baseUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().baseUrl();
    }

    /**
     * Set the baseUrl property: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string
     * (or Expression with resultType string).
     * 
     * @param baseUrl the baseUrl value to set.
     * @return the AzureKeyVaultLinkedService object itself.
     */
    public AzureKeyVaultLinkedService withBaseUrl(Object baseUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withBaseUrl(baseUrl);
        return this;
    }

    /**
     * Get the credential property: The credential reference containing authentication information.
     * 
     * @return the credential value.
     */
    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    /**
     * Set the credential property: The credential reference containing authentication information.
     * 
     * @param credential the credential value to set.
     * @return the AzureKeyVaultLinkedService object itself.
     */
    public AzureKeyVaultLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureKeyVaultLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AzureKeyVaultLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyVaultLinkedService.class);
}
