// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureMLLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Azure ML Studio Web Service linked service.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AzureMLLinkedService.class, visible = true)
@JsonTypeName("AzureML")
@Fluent
public final class AzureMLLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureML";

    /*
     * Azure ML Studio Web Service linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private AzureMLLinkedServiceTypeProperties innerTypeProperties = new AzureMLLinkedServiceTypeProperties();

    /**
     * Creates an instance of AzureMLLinkedService class.
     */
    public AzureMLLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Azure ML Studio Web Service linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private AzureMLLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureMLLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureMLLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureMLLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureMLLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the mlEndpoint property: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type:
     * string (or Expression with resultType string).
     * 
     * @return the mlEndpoint value.
     */
    public Object mlEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().mlEndpoint();
    }

    /**
     * Set the mlEndpoint property: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type:
     * string (or Expression with resultType string).
     * 
     * @param mlEndpoint the mlEndpoint value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withMlEndpoint(Object mlEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMlEndpoint(mlEndpoint);
        return this;
    }

    /**
     * Get the apiKey property: The API key for accessing the Azure ML model endpoint.
     * 
     * @return the apiKey value.
     */
    public SecretBase apiKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().apiKey();
    }

    /**
     * Set the apiKey property: The API key for accessing the Azure ML model endpoint.
     * 
     * @param apiKey the apiKey value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withApiKey(SecretBase apiKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApiKey(apiKey);
        return this;
    }

    /**
     * Get the updateResourceEndpoint property: The Update Resource REST URL for an Azure ML Studio Web Service
     * endpoint. Type: string (or Expression with resultType string).
     * 
     * @return the updateResourceEndpoint value.
     */
    public Object updateResourceEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().updateResourceEndpoint();
    }

    /**
     * Set the updateResourceEndpoint property: The Update Resource REST URL for an Azure ML Studio Web Service
     * endpoint. Type: string (or Expression with resultType string).
     * 
     * @param updateResourceEndpoint the updateResourceEndpoint value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withUpdateResourceEndpoint(Object updateResourceEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUpdateResourceEndpoint(updateResourceEndpoint);
        return this;
    }

    /**
     * Get the servicePrincipalId property: The ID of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string).
     * 
     * @return the servicePrincipalId value.
     */
    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    /**
     * Set the servicePrincipalId property: The ID of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression with resultType string).
     * 
     * @param servicePrincipalId the servicePrincipalId value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    /**
     * Get the servicePrincipalKey property: The key of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service.
     * 
     * @return the servicePrincipalKey value.
     */
    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    /**
     * Set the servicePrincipalKey property: The key of the service principal used to authenticate against the ARM-based
     * updateResourceEndpoint of an Azure ML Studio web service.
     * 
     * @param servicePrincipalKey the servicePrincipalKey value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    /**
     * Get the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @return the tenant value.
     */
    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    /**
     * Set the tenant property: The name or ID of the tenant to which the service principal belongs. Type: string (or
     * Expression with resultType string).
     * 
     * @param tenant the tenant value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    /**
     * Get the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @return the encryptedCredential value.
     */
    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    /**
     * Set the encryptedCredential property: The encrypted credential used for authentication. Credentials are encrypted
     * using the integration runtime credential manager. Type: string.
     * 
     * @param encryptedCredential the encryptedCredential value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    /**
     * Get the authentication property: Type of authentication (Required to specify MSI) used to connect to AzureML.
     * Type: string (or Expression with resultType string).
     * 
     * @return the authentication value.
     */
    public Object authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    /**
     * Set the authentication property: Type of authentication (Required to specify MSI) used to connect to AzureML.
     * Type: string (or Expression with resultType string).
     * 
     * @param authentication the authentication value to set.
     * @return the AzureMLLinkedService object itself.
     */
    public AzureMLLinkedService withAuthentication(Object authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureMLLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model AzureMLLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMLLinkedService.class);
}
