// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure ML WebService Input/Output file.
 */
@Fluent
public final class AzureMLWebServiceFile {
    /*
     * The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "filePath", required = true)
    private Object filePath;

    /*
     * Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
     */
    @JsonProperty(value = "linkedServiceName", required = true)
    private LinkedServiceReference linkedServiceName;

    /**
     * Creates an instance of AzureMLWebServiceFile class.
     */
    public AzureMLWebServiceFile() {
    }

    /**
     * Get the filePath property: The relative file path, including container name, in the Azure Blob Storage specified
     * by the LinkedService. Type: string (or Expression with resultType string).
     * 
     * @return the filePath value.
     */
    public Object filePath() {
        return this.filePath;
    }

    /**
     * Set the filePath property: The relative file path, including container name, in the Azure Blob Storage specified
     * by the LinkedService. Type: string (or Expression with resultType string).
     * 
     * @param filePath the filePath value to set.
     * @return the AzureMLWebServiceFile object itself.
     */
    public AzureMLWebServiceFile withFilePath(Object filePath) {
        this.filePath = filePath;
        return this;
    }

    /**
     * Get the linkedServiceName property: Reference to an Azure Storage LinkedService, where Azure ML WebService
     * Input/Output file located.
     * 
     * @return the linkedServiceName value.
     */
    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    /**
     * Set the linkedServiceName property: Reference to an Azure Storage LinkedService, where Azure ML WebService
     * Input/Output file located.
     * 
     * @param linkedServiceName the linkedServiceName value to set.
     * @return the AzureMLWebServiceFile object itself.
     */
    public AzureMLWebServiceFile withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (filePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property filePath in model AzureMLWebServiceFile"));
        }
        if (linkedServiceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property linkedServiceName in model AzureMLWebServiceFile"));
        } else {
            linkedServiceName().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMLWebServiceFile.class);
}
