// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Azure Table source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = AzureTableSource.class, visible = true)
@JsonTypeName("AzureTableSource")
@Fluent
public final class AzureTableSource extends TabularSource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "AzureTableSource";

    /*
     * Azure Table source query. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "azureTableSourceQuery")
    private Object azureTableSourceQuery;

    /*
     * Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "azureTableSourceIgnoreTableNotFound")
    private Object azureTableSourceIgnoreTableNotFound;

    /**
     * Creates an instance of AzureTableSource class.
     */
    public AzureTableSource() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the azureTableSourceQuery property: Azure Table source query. Type: string (or Expression with resultType
     * string).
     * 
     * @return the azureTableSourceQuery value.
     */
    public Object azureTableSourceQuery() {
        return this.azureTableSourceQuery;
    }

    /**
     * Set the azureTableSourceQuery property: Azure Table source query. Type: string (or Expression with resultType
     * string).
     * 
     * @param azureTableSourceQuery the azureTableSourceQuery value to set.
     * @return the AzureTableSource object itself.
     */
    public AzureTableSource withAzureTableSourceQuery(Object azureTableSourceQuery) {
        this.azureTableSourceQuery = azureTableSourceQuery;
        return this;
    }

    /**
     * Get the azureTableSourceIgnoreTableNotFound property: Azure Table source ignore table not found. Type: boolean
     * (or Expression with resultType boolean).
     * 
     * @return the azureTableSourceIgnoreTableNotFound value.
     */
    public Object azureTableSourceIgnoreTableNotFound() {
        return this.azureTableSourceIgnoreTableNotFound;
    }

    /**
     * Set the azureTableSourceIgnoreTableNotFound property: Azure Table source ignore table not found. Type: boolean
     * (or Expression with resultType boolean).
     * 
     * @param azureTableSourceIgnoreTableNotFound the azureTableSourceIgnoreTableNotFound value to set.
     * @return the AzureTableSource object itself.
     */
    public AzureTableSource withAzureTableSourceIgnoreTableNotFound(Object azureTableSourceIgnoreTableNotFound) {
        this.azureTableSourceIgnoreTableNotFound = azureTableSourceIgnoreTableNotFound;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureTableSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
