// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Big data pool reference type.
 */
@Fluent
public final class BigDataPoolParametrizationReference {
    /*
     * Big data pool reference type.
     */
    @JsonProperty(value = "type", required = true)
    private BigDataPoolReferenceType type;

    /*
     * Reference big data pool name. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "referenceName", required = true)
    private Object referenceName;

    /**
     * Creates an instance of BigDataPoolParametrizationReference class.
     */
    public BigDataPoolParametrizationReference() {
    }

    /**
     * Get the type property: Big data pool reference type.
     * 
     * @return the type value.
     */
    public BigDataPoolReferenceType type() {
        return this.type;
    }

    /**
     * Set the type property: Big data pool reference type.
     * 
     * @param type the type value to set.
     * @return the BigDataPoolParametrizationReference object itself.
     */
    public BigDataPoolParametrizationReference withType(BigDataPoolReferenceType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the referenceName property: Reference big data pool name. Type: string (or Expression with resultType
     * string).
     * 
     * @return the referenceName value.
     */
    public Object referenceName() {
        return this.referenceName;
    }

    /**
     * Set the referenceName property: Reference big data pool name. Type: string (or Expression with resultType
     * string).
     * 
     * @param referenceName the referenceName value to set.
     * @return the BigDataPoolParametrizationReference object itself.
     */
    public BigDataPoolParametrizationReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model BigDataPoolParametrizationReference"));
        }
        if (referenceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property referenceName in model BigDataPoolParametrizationReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BigDataPoolParametrizationReference.class);
}
