// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.BlobEventsTriggerTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/**
 * Trigger that runs every time a Blob event occurs.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = BlobEventsTrigger.class, visible = true)
@JsonTypeName("BlobEventsTrigger")
@Fluent
public final class BlobEventsTrigger extends MultiplePipelineTrigger {
    /*
     * Trigger type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "BlobEventsTrigger";

    /*
     * Blob Events Trigger properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private BlobEventsTriggerTypeProperties innerTypeProperties = new BlobEventsTriggerTypeProperties();

    /**
     * Creates an instance of BlobEventsTrigger class.
     */
    public BlobEventsTrigger() {
    }

    /**
     * Get the type property: Trigger type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Blob Events Trigger properties.
     * 
     * @return the innerTypeProperties value.
     */
    private BlobEventsTriggerTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BlobEventsTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        super.withPipelines(pipelines);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BlobEventsTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BlobEventsTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the blobPathBeginsWith property: The blob path must begin with the pattern provided for trigger to fire. For
     * example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records
     * container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     * 
     * @return the blobPathBeginsWith value.
     */
    public String blobPathBeginsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathBeginsWith();
    }

    /**
     * Set the blobPathBeginsWith property: The blob path must begin with the pattern provided for trigger to fire. For
     * example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records
     * container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     * 
     * @param blobPathBeginsWith the blobPathBeginsWith value to set.
     * @return the BlobEventsTrigger object itself.
     */
    public BlobEventsTrigger withBlobPathBeginsWith(String blobPathBeginsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathBeginsWith(blobPathBeginsWith);
        return this;
    }

    /**
     * Get the blobPathEndsWith property: The blob path must end with the pattern provided for trigger to fire. For
     * example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one
     * of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     * 
     * @return the blobPathEndsWith value.
     */
    public String blobPathEndsWith() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().blobPathEndsWith();
    }

    /**
     * Set the blobPathEndsWith property: The blob path must end with the pattern provided for trigger to fire. For
     * example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one
     * of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     * 
     * @param blobPathEndsWith the blobPathEndsWith value to set.
     * @return the BlobEventsTrigger object itself.
     */
    public BlobEventsTrigger withBlobPathEndsWith(String blobPathEndsWith) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withBlobPathEndsWith(blobPathEndsWith);
        return this;
    }

    /**
     * Get the ignoreEmptyBlobs property: If set to true, blobs with zero bytes will be ignored.
     * 
     * @return the ignoreEmptyBlobs value.
     */
    public Boolean ignoreEmptyBlobs() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ignoreEmptyBlobs();
    }

    /**
     * Set the ignoreEmptyBlobs property: If set to true, blobs with zero bytes will be ignored.
     * 
     * @param ignoreEmptyBlobs the ignoreEmptyBlobs value to set.
     * @return the BlobEventsTrigger object itself.
     */
    public BlobEventsTrigger withIgnoreEmptyBlobs(Boolean ignoreEmptyBlobs) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withIgnoreEmptyBlobs(ignoreEmptyBlobs);
        return this;
    }

    /**
     * Get the events property: The type of events that cause this trigger to fire.
     * 
     * @return the events value.
     */
    public List<BlobEventTypes> events() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().events();
    }

    /**
     * Set the events property: The type of events that cause this trigger to fire.
     * 
     * @param events the events value to set.
     * @return the BlobEventsTrigger object itself.
     */
    public BlobEventsTrigger withEvents(List<BlobEventTypes> events) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withEvents(events);
        return this;
    }

    /**
     * Get the scope property: The ARM resource ID of the Storage Account.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    /**
     * Set the scope property: The ARM resource ID of the Storage Account.
     * 
     * @param scope the scope value to set.
     * @return the BlobEventsTrigger object itself.
     */
    public BlobEventsTrigger withScope(String scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new BlobEventsTriggerTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model BlobEventsTrigger"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BlobEventsTrigger.class);
}
