// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.datafactory.fluent.models.CassandraTableDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The Cassandra database dataset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = CassandraTableDataset.class, visible = true)
@JsonTypeName("CassandraTable")
@Fluent
public final class CassandraTableDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "CassandraTable";

    /*
     * Cassandra dataset properties.
     */
    @JsonProperty(value = "typeProperties")
    private CassandraTableDatasetTypeProperties innerTypeProperties;

    /**
     * Creates an instance of CassandraTableDataset class.
     */
    public CassandraTableDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Cassandra dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private CassandraTableDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CassandraTableDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the tableName property: The table name of the Cassandra database. Type: string (or Expression with resultType
     * string).
     * 
     * @return the tableName value.
     */
    public Object tableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableName();
    }

    /**
     * Set the tableName property: The table name of the Cassandra database. Type: string (or Expression with resultType
     * string).
     * 
     * @param tableName the tableName value to set.
     * @return the CassandraTableDataset object itself.
     */
    public CassandraTableDataset withTableName(Object tableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CassandraTableDatasetTypeProperties();
        }
        this.innerTypeProperties().withTableName(tableName);
        return this;
    }

    /**
     * Get the keyspace property: The keyspace of the Cassandra database. Type: string (or Expression with resultType
     * string).
     * 
     * @return the keyspace value.
     */
    public Object keyspace() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().keyspace();
    }

    /**
     * Set the keyspace property: The keyspace of the Cassandra database. Type: string (or Expression with resultType
     * string).
     * 
     * @param keyspace the keyspace value to set.
     * @return the CassandraTableDataset object itself.
     */
    public CassandraTableDataset withKeyspace(Object keyspace) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CassandraTableDatasetTypeProperties();
        }
        this.innerTypeProperties().withKeyspace(keyspace);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() != null) {
            innerTypeProperties().validate();
        }
    }
}
