// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of ChangeDataCaptureResource.
 */
public interface ChangeDataCaptureResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The resource name.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The resource type.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: Etag identifies change in the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the additionalProperties property: Change data capture resource type.
     * 
     * @return the additionalProperties value.
     */
    Map<String, Object> additionalProperties();

    /**
     * Gets the folder property: The folder that this CDC is in. If not specified, CDC will appear at the root level.
     * 
     * @return the folder value.
     */
    ChangeDataCaptureFolder folder();

    /**
     * Gets the description property: The description of the change data capture.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the sourceConnectionsInfo property: List of sources connections that can be used as sources in the CDC.
     * 
     * @return the sourceConnectionsInfo value.
     */
    List<MapperSourceConnectionsInfo> sourceConnectionsInfo();

    /**
     * Gets the targetConnectionsInfo property: List of target connections that can be used as sources in the CDC.
     * 
     * @return the targetConnectionsInfo value.
     */
    List<MapperTargetConnectionsInfo> targetConnectionsInfo();

    /**
     * Gets the policy property: CDC policy.
     * 
     * @return the policy value.
     */
    MapperPolicy policy();

    /**
     * Gets the allowVNetOverride property: A boolean to determine if the vnet configuration needs to be overwritten.
     * 
     * @return the allowVNetOverride value.
     */
    Boolean allowVNetOverride();

    /**
     * Gets the status property: Status of the CDC as to if it is running or stopped.
     * 
     * @return the status value.
     */
    String status();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner object.
     * 
     * @return the inner object.
     */
    ChangeDataCaptureResourceInner innerModel();

    /**
     * The entirety of the ChangeDataCaptureResource definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithSourceConnectionsInfo,
        DefinitionStages.WithTargetConnectionsInfo, DefinitionStages.WithPolicy, DefinitionStages.WithCreate {
    }

    /**
     * The ChangeDataCaptureResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ChangeDataCaptureResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, factoryName.
             * 
             * @param resourceGroupName The resource group name.
             * @param factoryName The factory name.
             * @return the next definition stage.
             */
            WithSourceConnectionsInfo withExistingFactory(String resourceGroupName, String factoryName);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify sourceConnectionsInfo.
         */
        interface WithSourceConnectionsInfo {
            /**
             * Specifies the sourceConnectionsInfo property: List of sources connections that can be used as sources in
             * the CDC..
             * 
             * @param sourceConnectionsInfo List of sources connections that can be used as sources in the CDC.
             * @return the next definition stage.
             */
            WithTargetConnectionsInfo
                withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify targetConnectionsInfo.
         */
        interface WithTargetConnectionsInfo {
            /**
             * Specifies the targetConnectionsInfo property: List of target connections that can be used as sources in
             * the CDC..
             * 
             * @param targetConnectionsInfo List of target connections that can be used as sources in the CDC.
             * @return the next definition stage.
             */
            WithPolicy withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify policy.
         */
        interface WithPolicy {
            /**
             * Specifies the policy property: CDC policy.
             * 
             * @param policy CDC policy.
             * @return the next definition stage.
             */
            WithCreate withPolicy(MapperPolicy policy);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition which contains all the minimum required properties for
         * the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithAdditionalProperties, DefinitionStages.WithFolder,
            DefinitionStages.WithDescription, DefinitionStages.WithAllowVNetOverride, DefinitionStages.WithStatus,
            DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ChangeDataCaptureResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ChangeDataCaptureResource create(Context context);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify additionalProperties.
         */
        interface WithAdditionalProperties {
            /**
             * Specifies the additionalProperties property: Change data capture resource type..
             * 
             * @param additionalProperties Change data capture resource type.
             * @return the next definition stage.
             */
            WithCreate withAdditionalProperties(Map<String, Object> additionalProperties);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify folder.
         */
        interface WithFolder {
            /**
             * Specifies the folder property: The folder that this CDC is in. If not specified, CDC will appear at the
             * root level..
             * 
             * @param folder The folder that this CDC is in. If not specified, CDC will appear at the root level.
             * @return the next definition stage.
             */
            WithCreate withFolder(ChangeDataCaptureFolder folder);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: The description of the change data capture..
             * 
             * @param description The description of the change data capture.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify allowVNetOverride.
         */
        interface WithAllowVNetOverride {
            /**
             * Specifies the allowVNetOverride property: A boolean to determine if the vnet configuration needs to be
             * overwritten..
             * 
             * @param allowVNetOverride A boolean to determine if the vnet configuration needs to be overwritten.
             * @return the next definition stage.
             */
            WithCreate withAllowVNetOverride(Boolean allowVNetOverride);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify status.
         */
        interface WithStatus {
            /**
             * Specifies the status property: Status of the CDC as to if it is running or stopped..
             * 
             * @param status Status of the CDC as to if it is running or stopped.
             * @return the next definition stage.
             */
            WithCreate withStatus(String status);
        }

        /**
         * The stage of the ChangeDataCaptureResource definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the change data capture entity. Should only be specified for
             * update, for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the change data capture entity. Should only be specified for update, for which it
             * should match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the ChangeDataCaptureResource resource.
     * 
     * @return the stage of resource update.
     */
    ChangeDataCaptureResource.Update update();

    /**
     * The template for ChangeDataCaptureResource update.
     */
    interface Update extends UpdateStages.WithAdditionalProperties, UpdateStages.WithFolder,
        UpdateStages.WithDescription, UpdateStages.WithSourceConnectionsInfo, UpdateStages.WithTargetConnectionsInfo,
        UpdateStages.WithPolicy, UpdateStages.WithAllowVNetOverride, UpdateStages.WithStatus, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ChangeDataCaptureResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ChangeDataCaptureResource apply(Context context);
    }

    /**
     * The ChangeDataCaptureResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify additionalProperties.
         */
        interface WithAdditionalProperties {
            /**
             * Specifies the additionalProperties property: Change data capture resource type..
             * 
             * @param additionalProperties Change data capture resource type.
             * @return the next definition stage.
             */
            Update withAdditionalProperties(Map<String, Object> additionalProperties);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify folder.
         */
        interface WithFolder {
            /**
             * Specifies the folder property: The folder that this CDC is in. If not specified, CDC will appear at the
             * root level..
             * 
             * @param folder The folder that this CDC is in. If not specified, CDC will appear at the root level.
             * @return the next definition stage.
             */
            Update withFolder(ChangeDataCaptureFolder folder);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: The description of the change data capture..
             * 
             * @param description The description of the change data capture.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify sourceConnectionsInfo.
         */
        interface WithSourceConnectionsInfo {
            /**
             * Specifies the sourceConnectionsInfo property: List of sources connections that can be used as sources in
             * the CDC..
             * 
             * @param sourceConnectionsInfo List of sources connections that can be used as sources in the CDC.
             * @return the next definition stage.
             */
            Update withSourceConnectionsInfo(List<MapperSourceConnectionsInfo> sourceConnectionsInfo);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify targetConnectionsInfo.
         */
        interface WithTargetConnectionsInfo {
            /**
             * Specifies the targetConnectionsInfo property: List of target connections that can be used as sources in
             * the CDC..
             * 
             * @param targetConnectionsInfo List of target connections that can be used as sources in the CDC.
             * @return the next definition stage.
             */
            Update withTargetConnectionsInfo(List<MapperTargetConnectionsInfo> targetConnectionsInfo);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify policy.
         */
        interface WithPolicy {
            /**
             * Specifies the policy property: CDC policy.
             * 
             * @param policy CDC policy.
             * @return the next definition stage.
             */
            Update withPolicy(MapperPolicy policy);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify allowVNetOverride.
         */
        interface WithAllowVNetOverride {
            /**
             * Specifies the allowVNetOverride property: A boolean to determine if the vnet configuration needs to be
             * overwritten..
             * 
             * @param allowVNetOverride A boolean to determine if the vnet configuration needs to be overwritten.
             * @return the next definition stage.
             */
            Update withAllowVNetOverride(Boolean allowVNetOverride);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify status.
         */
        interface WithStatus {
            /**
             * Specifies the status property: Status of the CDC as to if it is running or stopped..
             * 
             * @param status Status of the CDC as to if it is running or stopped.
             * @return the next definition stage.
             */
            Update withStatus(String status);
        }

        /**
         * The stage of the ChangeDataCaptureResource update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the change data capture entity. Should only be specified for
             * update, for which it should match existing entity or can be * for unconditional update..
             * 
             * @param ifMatch ETag of the change data capture entity. Should only be specified for update, for which it
             * should match existing entity or can be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ChangeDataCaptureResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ChangeDataCaptureResource refresh(Context context);

    /**
     * Starts a change data capture.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> startWithResponse(Context context);

    /**
     * Starts a change data capture.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void start();

    /**
     * Stops a change data capture.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> stopWithResponse(Context context);

    /**
     * Stops a change data capture.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void stop();
}
