// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ChangeDataCaptures.
 */
public interface ChangeDataCaptures {
    /**
     * Lists all resources of type change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of change data capture resources as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ChangeDataCaptureResource> listByFactory(String resourceGroupName, String factoryName);

    /**
     * Lists all resources of type change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of change data capture resources as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ChangeDataCaptureResource> listByFactory(String resourceGroupName, String factoryName,
        Context context);

    /**
     * Gets a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param ifNoneMatch ETag of the change data capture entity. Should only be specified for get. If the ETag matches
     * the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture along with {@link Response}.
     */
    Response<ChangeDataCaptureResource> getWithResponse(String resourceGroupName, String factoryName,
        String changeDataCaptureName, String ifNoneMatch, Context context);

    /**
     * Gets a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture.
     */
    ChangeDataCaptureResource get(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Deletes a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Deletes a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Starts a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> startWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Starts a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void start(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Stops a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> stopWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Stops a change data capture.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void stop(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Gets the current status for the change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current status for the change data capture resource along with {@link Response}.
     */
    Response<String> statusWithResponse(String resourceGroupName, String factoryName, String changeDataCaptureName,
        Context context);

    /**
     * Gets the current status for the change data capture resource.
     * 
     * @param resourceGroupName The resource group name.
     * @param factoryName The factory name.
     * @param changeDataCaptureName The change data capture name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current status for the change data capture resource.
     */
    String status(String resourceGroupName, String factoryName, String changeDataCaptureName);

    /**
     * Gets a change data capture.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture along with {@link Response}.
     */
    ChangeDataCaptureResource getById(String id);

    /**
     * Gets a change data capture.
     * 
     * @param id the resource ID.
     * @param ifNoneMatch ETag of the change data capture entity. Should only be specified for get. If the ETag matches
     * the existing entity tag, or if * was provided, then no content will be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a change data capture along with {@link Response}.
     */
    Response<ChangeDataCaptureResource> getByIdWithResponse(String id, String ifNoneMatch, Context context);

    /**
     * Deletes a change data capture.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a change data capture.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new ChangeDataCaptureResource resource.
     * 
     * @param name resource name.
     * @return the first stage of the new ChangeDataCaptureResource definition.
     */
    ChangeDataCaptureResource.DefinitionStages.Blank define(String name);
}
