// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CmdkeySetupTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The custom setup of running cmdkey commands.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = CmdkeySetup.class, visible = true)
@JsonTypeName("CmdkeySetup")
@Fluent
public final class CmdkeySetup extends CustomSetupBase {
    /*
     * The type of custom setup.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "CmdkeySetup";

    /*
     * Cmdkey command custom setup type properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private CmdkeySetupTypeProperties innerTypeProperties = new CmdkeySetupTypeProperties();

    /**
     * Creates an instance of CmdkeySetup class.
     */
    public CmdkeySetup() {
    }

    /**
     * Get the type property: The type of custom setup.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Cmdkey command custom setup type properties.
     * 
     * @return the innerTypeProperties value.
     */
    private CmdkeySetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * Get the targetName property: The server name of data source access. Type: string.
     * 
     * @return the targetName value.
     */
    public Object targetName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().targetName();
    }

    /**
     * Set the targetName property: The server name of data source access. Type: string.
     * 
     * @param targetName the targetName value to set.
     * @return the CmdkeySetup object itself.
     */
    public CmdkeySetup withTargetName(Object targetName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withTargetName(targetName);
        return this;
    }

    /**
     * Get the username property: The user name of data source access. Type: string.
     * 
     * @return the username value.
     */
    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    /**
     * Set the username property: The user name of data source access. Type: string.
     * 
     * @param username the username value to set.
     * @return the CmdkeySetup object itself.
     */
    public CmdkeySetup withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    /**
     * Get the password property: The password of data source access.
     * 
     * @return the password value.
     */
    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    /**
     * Set the password property: The password of data source access.
     * 
     * @param password the password value to set.
     * @return the CmdkeySetup object itself.
     */
    public CmdkeySetup withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CmdkeySetupTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property innerTypeProperties in model CmdkeySetup"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CmdkeySetup.class);
}
