// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.LicensedComponentSetupTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The custom setup of installing 3rd party components.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = ComponentSetup.class, visible = true)
@JsonTypeName("ComponentSetup")
@Fluent
public final class ComponentSetup extends CustomSetupBase {
    /*
     * The type of custom setup.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "ComponentSetup";

    /*
     * Install 3rd party component type properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private LicensedComponentSetupTypeProperties innerTypeProperties = new LicensedComponentSetupTypeProperties();

    /**
     * Creates an instance of ComponentSetup class.
     */
    public ComponentSetup() {
    }

    /**
     * Get the type property: The type of custom setup.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: Install 3rd party component type properties.
     * 
     * @return the innerTypeProperties value.
     */
    private LicensedComponentSetupTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * Get the componentName property: The name of the 3rd party component.
     * 
     * @return the componentName value.
     */
    public String componentName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().componentName();
    }

    /**
     * Set the componentName property: The name of the 3rd party component.
     * 
     * @param componentName the componentName value to set.
     * @return the ComponentSetup object itself.
     */
    public ComponentSetup withComponentName(String componentName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withComponentName(componentName);
        return this;
    }

    /**
     * Get the licenseKey property: The license key to activate the component.
     * 
     * @return the licenseKey value.
     */
    public SecretBase licenseKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().licenseKey();
    }

    /**
     * Set the licenseKey property: The license key to activate the component.
     * 
     * @param licenseKey the licenseKey value to set.
     * @return the ComponentSetup object itself.
     */
    public ComponentSetup withLicenseKey(SecretBase licenseKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new LicensedComponentSetupTypeProperties();
        }
        this.innerTypeProperties().withLicenseKey(licenseKey);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model ComponentSetup"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ComponentSetup.class);
}
