// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of the spark config.
 */
public final class ConfigurationType extends ExpandableStringEnum<ConfigurationType> {
    /**
     * Static value Default for ConfigurationType.
     */
    public static final ConfigurationType DEFAULT = fromString("Default");

    /**
     * Static value Customized for ConfigurationType.
     */
    public static final ConfigurationType CUSTOMIZED = fromString("Customized");

    /**
     * Static value Artifact for ConfigurationType.
     */
    public static final ConfigurationType ARTIFACT = fromString("Artifact");

    /**
     * Creates a new instance of ConfigurationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConfigurationType() {
    }

    /**
     * Creates or finds a ConfigurationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConfigurationType.
     */
    @JsonCreator
    public static ConfigurationType fromString(String name) {
        return fromString(name, ConfigurationType.class);
    }

    /**
     * Gets known ConfigurationType values.
     * 
     * @return known ConfigurationType values.
     */
    public static Collection<ConfigurationType> values() {
        return values(ConfigurationType.class);
    }
}
