// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/**
 * CopyComputeScale properties for managed integration runtime.
 */
@Fluent
public final class CopyComputeScaleProperties {
    /*
     * DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
     */
    @JsonProperty(value = "dataIntegrationUnit")
    private Integer dataIntegrationUnit;

    /*
     * Time to live (in minutes) setting of integration runtime which will execute copy activity.
     */
    @JsonProperty(value = "timeToLive")
    private Integer timeToLive;

    /*
     * CopyComputeScale properties for managed integration runtime.
     */
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of CopyComputeScaleProperties class.
     */
    public CopyComputeScaleProperties() {
    }

    /**
     * Get the dataIntegrationUnit property: DIU number setting reserved for copy activity execution. Supported values
     * are multiples of 4 in range 4-256.
     * 
     * @return the dataIntegrationUnit value.
     */
    public Integer dataIntegrationUnit() {
        return this.dataIntegrationUnit;
    }

    /**
     * Set the dataIntegrationUnit property: DIU number setting reserved for copy activity execution. Supported values
     * are multiples of 4 in range 4-256.
     * 
     * @param dataIntegrationUnit the dataIntegrationUnit value to set.
     * @return the CopyComputeScaleProperties object itself.
     */
    public CopyComputeScaleProperties withDataIntegrationUnit(Integer dataIntegrationUnit) {
        this.dataIntegrationUnit = dataIntegrationUnit;
        return this;
    }

    /**
     * Get the timeToLive property: Time to live (in minutes) setting of integration runtime which will execute copy
     * activity.
     * 
     * @return the timeToLive value.
     */
    public Integer timeToLive() {
        return this.timeToLive;
    }

    /**
     * Set the timeToLive property: Time to live (in minutes) setting of integration runtime which will execute copy
     * activity.
     * 
     * @param timeToLive the timeToLive value to set.
     * @return the CopyComputeScaleProperties object itself.
     */
    public CopyComputeScaleProperties withTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    /**
     * Get the additionalProperties property: CopyComputeScale properties for managed integration runtime.
     * 
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: CopyComputeScale properties for managed integration runtime.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the CopyComputeScaleProperties object itself.
     */
    public CopyComputeScaleProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
