// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CosmosDbMongoDbApiCollectionDatasetTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * The CosmosDB (MongoDB API) database dataset.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = CosmosDbMongoDbApiCollectionDataset.class,
    visible = true)
@JsonTypeName("CosmosDbMongoDbApiCollection")
@Fluent
public final class CosmosDbMongoDbApiCollectionDataset extends Dataset {
    /*
     * Type of dataset.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "CosmosDbMongoDbApiCollection";

    /*
     * CosmosDB (MongoDB API) database dataset properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private CosmosDbMongoDbApiCollectionDatasetTypeProperties innerTypeProperties
        = new CosmosDbMongoDbApiCollectionDatasetTypeProperties();

    /**
     * Creates an instance of CosmosDbMongoDbApiCollectionDataset class.
     */
    public CosmosDbMongoDbApiCollectionDataset() {
    }

    /**
     * Get the type property: Type of dataset.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: CosmosDB (MongoDB API) database dataset properties.
     * 
     * @return the innerTypeProperties value.
     */
    private CosmosDbMongoDbApiCollectionDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiCollectionDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    /**
     * Get the collection property: The collection name of the CosmosDB (MongoDB API) database. Type: string (or
     * Expression with resultType string).
     * 
     * @return the collection value.
     */
    public Object collection() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().collection();
    }

    /**
     * Set the collection property: The collection name of the CosmosDB (MongoDB API) database. Type: string (or
     * Expression with resultType string).
     * 
     * @param collection the collection value to set.
     * @return the CosmosDbMongoDbApiCollectionDataset object itself.
     */
    public CosmosDbMongoDbApiCollectionDataset withCollection(Object collection) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CosmosDbMongoDbApiCollectionDatasetTypeProperties();
        }
        this.innerTypeProperties().withCollection(collection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model CosmosDbMongoDbApiCollectionDataset"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CosmosDbMongoDbApiCollectionDataset.class);
}
