// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CosmosDbMongoDbApiLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

/**
 * Linked service for CosmosDB (MongoDB API) data source.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type",
    defaultImpl = CosmosDbMongoDbApiLinkedService.class,
    visible = true)
@JsonTypeName("CosmosDbMongoDbApi")
@Fluent
public final class CosmosDbMongoDbApiLinkedService extends LinkedService {
    /*
     * Type of linked service.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "CosmosDbMongoDbApi";

    /*
     * CosmosDB (MongoDB API) linked service properties.
     */
    @JsonProperty(value = "typeProperties", required = true)
    private CosmosDbMongoDbApiLinkedServiceTypeProperties innerTypeProperties
        = new CosmosDbMongoDbApiLinkedServiceTypeProperties();

    /**
     * Creates an instance of CosmosDbMongoDbApiLinkedService class.
     */
    public CosmosDbMongoDbApiLinkedService() {
    }

    /**
     * Get the type property: Type of linked service.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the innerTypeProperties property: CosmosDB (MongoDB API) linked service properties.
     * 
     * @return the innerTypeProperties value.
     */
    private CosmosDbMongoDbApiLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbMongoDbApiLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    /**
     * Get the isServerVersionAbove32 property: Whether the CosmosDB (MongoDB API) server version is higher than 3.2.
     * The default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @return the isServerVersionAbove32 value.
     */
    public Object isServerVersionAbove32() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().isServerVersionAbove32();
    }

    /**
     * Set the isServerVersionAbove32 property: Whether the CosmosDB (MongoDB API) server version is higher than 3.2.
     * The default value is false. Type: boolean (or Expression with resultType boolean).
     * 
     * @param isServerVersionAbove32 the isServerVersionAbove32 value to set.
     * @return the CosmosDbMongoDbApiLinkedService object itself.
     */
    public CosmosDbMongoDbApiLinkedService withIsServerVersionAbove32(Object isServerVersionAbove32) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CosmosDbMongoDbApiLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIsServerVersionAbove32(isServerVersionAbove32);
        return this;
    }

    /**
     * Get the connectionString property: The CosmosDB (MongoDB API) connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @return the connectionString value.
     */
    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    /**
     * Set the connectionString property: The CosmosDB (MongoDB API) connection string. Type: string, SecureString or
     * AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     * 
     * @param connectionString the connectionString value to set.
     * @return the CosmosDbMongoDbApiLinkedService object itself.
     */
    public CosmosDbMongoDbApiLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CosmosDbMongoDbApiLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the database property: The name of the CosmosDB (MongoDB API) database that you want to access. Type: string
     * (or Expression with resultType string).
     * 
     * @return the database value.
     */
    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    /**
     * Set the database property: The name of the CosmosDB (MongoDB API) database that you want to access. Type: string
     * (or Expression with resultType string).
     * 
     * @param database the database value to set.
     * @return the CosmosDbMongoDbApiLinkedService object itself.
     */
    public CosmosDbMongoDbApiLinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CosmosDbMongoDbApiLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerTypeProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerTypeProperties in model CosmosDbMongoDbApiLinkedService"));
        } else {
            innerTypeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CosmosDbMongoDbApiLinkedService.class);
}
