// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A copy activity Azure CosmosDB (SQL API) Collection source.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", defaultImpl = CosmosDbSqlApiSource.class, visible = true)
@JsonTypeName("CosmosDbSqlApiSource")
@Fluent
public final class CosmosDbSqlApiSource extends CopySource {
    /*
     * Copy source type.
     */
    @JsonTypeId
    @JsonProperty(value = "type", required = true)
    private String type = "CosmosDbSqlApiSource";

    /*
     * SQL API query. Type: string (or Expression with resultType string).
     */
    @JsonProperty(value = "query")
    private Object query;

    /*
     * Page size of the result. Type: integer (or Expression with resultType integer).
     */
    @JsonProperty(value = "pageSize")
    private Object pageSize;

    /*
     * Preferred regions. Type: array of strings (or Expression with resultType array of strings).
     */
    @JsonProperty(value = "preferredRegions")
    private Object preferredRegions;

    /*
     * Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
     */
    @JsonProperty(value = "detectDatetime")
    private Object detectDatetime;

    /*
     * Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JsonProperty(value = "additionalColumns")
    private Object additionalColumns;

    /**
     * Creates an instance of CosmosDbSqlApiSource class.
     */
    public CosmosDbSqlApiSource() {
    }

    /**
     * Get the type property: Copy source type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the query property: SQL API query. Type: string (or Expression with resultType string).
     * 
     * @return the query value.
     */
    public Object query() {
        return this.query;
    }

    /**
     * Set the query property: SQL API query. Type: string (or Expression with resultType string).
     * 
     * @param query the query value to set.
     * @return the CosmosDbSqlApiSource object itself.
     */
    public CosmosDbSqlApiSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    /**
     * Get the pageSize property: Page size of the result. Type: integer (or Expression with resultType integer).
     * 
     * @return the pageSize value.
     */
    public Object pageSize() {
        return this.pageSize;
    }

    /**
     * Set the pageSize property: Page size of the result. Type: integer (or Expression with resultType integer).
     * 
     * @param pageSize the pageSize value to set.
     * @return the CosmosDbSqlApiSource object itself.
     */
    public CosmosDbSqlApiSource withPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    /**
     * Get the preferredRegions property: Preferred regions. Type: array of strings (or Expression with resultType array
     * of strings).
     * 
     * @return the preferredRegions value.
     */
    public Object preferredRegions() {
        return this.preferredRegions;
    }

    /**
     * Set the preferredRegions property: Preferred regions. Type: array of strings (or Expression with resultType array
     * of strings).
     * 
     * @param preferredRegions the preferredRegions value to set.
     * @return the CosmosDbSqlApiSource object itself.
     */
    public CosmosDbSqlApiSource withPreferredRegions(Object preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    /**
     * Get the detectDatetime property: Whether detect primitive values as datetime values. Type: boolean (or Expression
     * with resultType boolean).
     * 
     * @return the detectDatetime value.
     */
    public Object detectDatetime() {
        return this.detectDatetime;
    }

    /**
     * Set the detectDatetime property: Whether detect primitive values as datetime values. Type: boolean (or Expression
     * with resultType boolean).
     * 
     * @param detectDatetime the detectDatetime value to set.
     * @return the CosmosDbSqlApiSource object itself.
     */
    public CosmosDbSqlApiSource withDetectDatetime(Object detectDatetime) {
        this.detectDatetime = detectDatetime;
        return this;
    }

    /**
     * Get the additionalColumns property: Specifies the additional columns to be added to source data. Type: array of
     * objects(AdditionalColumns) (or Expression with resultType array of objects).
     * 
     * @return the additionalColumns value.
     */
    public Object additionalColumns() {
        return this.additionalColumns;
    }

    /**
     * Set the additionalColumns property: Specifies the additional columns to be added to source data. Type: array of
     * objects(AdditionalColumns) (or Expression with resultType array of objects).
     * 
     * @param additionalColumns the additionalColumns value to set.
     * @return the CosmosDbSqlApiSource object itself.
     */
    public CosmosDbSqlApiSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbSqlApiSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbSqlApiSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbSqlApiSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CosmosDbSqlApiSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
