// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The linked integration runtime information.
 */
@Fluent
public final class CreateLinkedIntegrationRuntimeRequest {
    /*
     * The name of the linked integration runtime.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The ID of the subscription that the linked integration runtime belongs to.
     */
    @JsonProperty(value = "subscriptionId")
    private String subscriptionId;

    /*
     * The name of the data factory that the linked integration runtime belongs to.
     */
    @JsonProperty(value = "dataFactoryName")
    private String dataFactoryName;

    /*
     * The location of the data factory that the linked integration runtime belongs to.
     */
    @JsonProperty(value = "dataFactoryLocation")
    private String dataFactoryLocation;

    /**
     * Creates an instance of CreateLinkedIntegrationRuntimeRequest class.
     */
    public CreateLinkedIntegrationRuntimeRequest() {
    }

    /**
     * Get the name property: The name of the linked integration runtime.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the linked integration runtime.
     * 
     * @param name the name value to set.
     * @return the CreateLinkedIntegrationRuntimeRequest object itself.
     */
    public CreateLinkedIntegrationRuntimeRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the subscriptionId property: The ID of the subscription that the linked integration runtime belongs to.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: The ID of the subscription that the linked integration runtime belongs to.
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the CreateLinkedIntegrationRuntimeRequest object itself.
     */
    public CreateLinkedIntegrationRuntimeRequest withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the dataFactoryName property: The name of the data factory that the linked integration runtime belongs to.
     * 
     * @return the dataFactoryName value.
     */
    public String dataFactoryName() {
        return this.dataFactoryName;
    }

    /**
     * Set the dataFactoryName property: The name of the data factory that the linked integration runtime belongs to.
     * 
     * @param dataFactoryName the dataFactoryName value to set.
     * @return the CreateLinkedIntegrationRuntimeRequest object itself.
     */
    public CreateLinkedIntegrationRuntimeRequest withDataFactoryName(String dataFactoryName) {
        this.dataFactoryName = dataFactoryName;
        return this;
    }

    /**
     * Get the dataFactoryLocation property: The location of the data factory that the linked integration runtime
     * belongs to.
     * 
     * @return the dataFactoryLocation value.
     */
    public String dataFactoryLocation() {
        return this.dataFactoryLocation;
    }

    /**
     * Set the dataFactoryLocation property: The location of the data factory that the linked integration runtime
     * belongs to.
     * 
     * @param dataFactoryLocation the dataFactoryLocation value to set.
     * @return the CreateLinkedIntegrationRuntimeRequest object itself.
     */
    public CreateLinkedIntegrationRuntimeRequest withDataFactoryLocation(String dataFactoryLocation) {
        this.dataFactoryLocation = dataFactoryLocation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
