// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A list of credential resources.
 */
@Fluent
public final class CredentialListResponse {
    /*
     * List of credentials.
     */
    @JsonProperty(value = "value", required = true)
    private List<CredentialResourceInner> value;

    /*
     * The link to the next page of results, if any remaining results exist.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CredentialListResponse class.
     */
    public CredentialListResponse() {
    }

    /**
     * Get the value property: List of credentials.
     * 
     * @return the value value.
     */
    public List<CredentialResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of credentials.
     * 
     * @param value the value value to set.
     * @return the CredentialListResponse object itself.
     */
    public CredentialListResponse withValue(List<CredentialResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of results, if any remaining results exist.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of results, if any remaining results exist.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CredentialListResponse object itself.
     */
    public CredentialListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model CredentialListResponse"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CredentialListResponse.class);
}
