// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Reference objects for custom activity.
 */
@Fluent
public final class CustomActivityReferenceObject {
    /*
     * Linked service references.
     */
    @JsonProperty(value = "linkedServices")
    private List<LinkedServiceReference> linkedServices;

    /*
     * Dataset references.
     */
    @JsonProperty(value = "datasets")
    private List<DatasetReference> datasets;

    /**
     * Creates an instance of CustomActivityReferenceObject class.
     */
    public CustomActivityReferenceObject() {
    }

    /**
     * Get the linkedServices property: Linked service references.
     * 
     * @return the linkedServices value.
     */
    public List<LinkedServiceReference> linkedServices() {
        return this.linkedServices;
    }

    /**
     * Set the linkedServices property: Linked service references.
     * 
     * @param linkedServices the linkedServices value to set.
     * @return the CustomActivityReferenceObject object itself.
     */
    public CustomActivityReferenceObject withLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    /**
     * Get the datasets property: Dataset references.
     * 
     * @return the datasets value.
     */
    public List<DatasetReference> datasets() {
        return this.datasets;
    }

    /**
     * Set the datasets property: Dataset references.
     * 
     * @param datasets the datasets value to set.
     * @return the CustomActivityReferenceObject object itself.
     */
    public CustomActivityReferenceObject withDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linkedServices() != null) {
            linkedServices().forEach(e -> e.validate());
        }
        if (datasets() != null) {
            datasets().forEach(e -> e.validate());
        }
    }
}
