// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Compute type of the cluster which will execute data flow job.
 */
public final class DataFlowComputeType extends ExpandableStringEnum<DataFlowComputeType> {
    /**
     * Static value General for DataFlowComputeType.
     */
    public static final DataFlowComputeType GENERAL = fromString("General");

    /**
     * Static value MemoryOptimized for DataFlowComputeType.
     */
    public static final DataFlowComputeType MEMORY_OPTIMIZED = fromString("MemoryOptimized");

    /**
     * Static value ComputeOptimized for DataFlowComputeType.
     */
    public static final DataFlowComputeType COMPUTE_OPTIMIZED = fromString("ComputeOptimized");

    /**
     * Creates a new instance of DataFlowComputeType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DataFlowComputeType() {
    }

    /**
     * Creates or finds a DataFlowComputeType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DataFlowComputeType.
     */
    @JsonCreator
    public static DataFlowComputeType fromString(String name) {
        return fromString(name, DataFlowComputeType.class);
    }

    /**
     * Gets known DataFlowComputeType values.
     * 
     * @return known DataFlowComputeType values.
     */
    public static Collection<DataFlowComputeType> values() {
        return values(DataFlowComputeType.class);
    }
}
