// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.datafactory.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Request body structure for data flow debug command.
 */
@Fluent
public final class DataFlowDebugCommandRequest {
    /*
     * The ID of data flow debug session.
     */
    @JsonProperty(value = "sessionId")
    private String sessionId;

    /*
     * The command type.
     */
    @JsonProperty(value = "command")
    private DataFlowDebugCommandType command;

    /*
     * The command payload object.
     */
    @JsonProperty(value = "commandPayload")
    private DataFlowDebugCommandPayload commandPayload;

    /**
     * Creates an instance of DataFlowDebugCommandRequest class.
     */
    public DataFlowDebugCommandRequest() {
    }

    /**
     * Get the sessionId property: The ID of data flow debug session.
     * 
     * @return the sessionId value.
     */
    public String sessionId() {
        return this.sessionId;
    }

    /**
     * Set the sessionId property: The ID of data flow debug session.
     * 
     * @param sessionId the sessionId value to set.
     * @return the DataFlowDebugCommandRequest object itself.
     */
    public DataFlowDebugCommandRequest withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    /**
     * Get the command property: The command type.
     * 
     * @return the command value.
     */
    public DataFlowDebugCommandType command() {
        return this.command;
    }

    /**
     * Set the command property: The command type.
     * 
     * @param command the command value to set.
     * @return the DataFlowDebugCommandRequest object itself.
     */
    public DataFlowDebugCommandRequest withCommand(DataFlowDebugCommandType command) {
        this.command = command;
        return this;
    }

    /**
     * Get the commandPayload property: The command payload object.
     * 
     * @return the commandPayload value.
     */
    public DataFlowDebugCommandPayload commandPayload() {
        return this.commandPayload;
    }

    /**
     * Set the commandPayload property: The command payload object.
     * 
     * @param commandPayload the commandPayload value to set.
     * @return the DataFlowDebugCommandRequest object itself.
     */
    public DataFlowDebugCommandRequest withCommandPayload(DataFlowDebugCommandPayload commandPayload) {
        this.commandPayload = commandPayload;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (commandPayload() != null) {
            commandPayload().validate();
        }
    }
}
